import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDate from "alexandria-ui-elements/src/displays/components/Date";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiDateEditable from "alexandria-ui-elements/src/displays/components/DateEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DateExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import DateExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DateExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DateExamplesMoldNotifier(this);
		this.requester = new DateExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1448358706" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1448358706.a27500921" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1448358706.a286514541" format="filled" layout="vertical" spacing="8">
							<UiDate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1448358706.a286514541.a499218984" format="body1 widgetDemo" pattern="MM/DD/YYYY">
							</UiDate>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1448358706.a286514541.a713066007" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1448358706.a286514541.a713066007.a_2135750664" mode="normal" language="Html" value="Date(pattern=&quot;MM/DD/YYYY&quot;) date1&lt;br/&gt;&lt;br/&gt;
								&lt;i&gt;pattern&lt;/i&gt; is defined using &lt;a href=&quot;https://momentjs.com/docs/#/displaying/format/&quot; target=&quot;_blank&quot;&gt;momentjs format&lt;/a&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1192399921" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1192399921.a_996577426" format="h6" mode="normal" value="No facets with Mode">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1192399921.a_495095310" format="filled" layout="vertical" spacing="8">
							<UiDate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1192399921.a_495095310.a_1504748983" format="body1 widgetDemo" pattern="DD/MM/YYYY" mode="fromnow">
							</UiDate>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1192399921.a_495095310.a_1289154336" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1192399921.a_495095310.a_1289154336.a1361178521" mode="normal" language="Html" value="Date(mode=FromNow) date2">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1026109868" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1026109868.a_338572634" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1026109868.a1922455330" format="filled" layout="vertical" spacing="8">
							<UiDateEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1026109868.a1922455330.a_1701262487" format="body1 widgetDemo" pattern="DD/MM/YYYY">
							</UiDateEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1026109868.a1922455330.a1538635056" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1882699378.a_1026109868.a1922455330.a1538635056.a856543417" mode="normal" language="Html" value="Date date3 as Editable">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159679739" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159679739.a651347910" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159679739.a651347910.a_157398842" format="h6" mode="normal" value="Editable facet with timePicker">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159679739.a651347910.a136534567" format="filled" layout="vertical" spacing="8">
							<UiDateEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159679739.a651347910.a136534567.a589736842" format="body1 widgetDemo" pattern="DD/MM/YYYY HH:mm" timePicker={true}>
							</UiDateEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159679739.a651347910.a136534567.a1369614955" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159679739.a651347910.a136534567.a1369614955.a_234897701" mode="normal" language="Html" value="Date date4 as Editable(timePicker=true)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159679739.a_400852012" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159679739.a_400852012.a594420547" format="h6" mode="normal" value="Editable facet allowing empty">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159679739.a_400852012.a2049027097" format="filled" layout="vertical" spacing="8">
							<UiDateEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159679739.a_400852012.a2049027097.a_1414231125" format="body1 widgetDemo" pattern="DD/MM/YYYY HH:mm" allowEmpty={true}>
							</UiDateEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159679739.a_400852012.a2049027097.a383321111" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159679739.a_400852012.a2049027097.a383321111.a_1032935812" mode="normal" language="Html" value="Date date as Editable(allowEmpty=true)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(DateExamplesMold));
DisplayFactory.register("DateExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(DateExamplesMold)));