import Requester from "./Requester";

export default class ActionableRequester extends Requester {
	constructor(element) {
		super(element);
	};
	checkSign = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "checkSign", s: "actionable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	checkAffirmed = () => {
	    if (this.addToHistory()) return;
	    this.pushService.send({ op: "checkAffirmed", s: "actionable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	cancelAffirm = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "cancelAffirm", s: "actionable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "actionable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}