import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSelectorTabs from "alexandria-ui-elements/src/displays/components/SelectorTabs";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiSelectorMenu from "alexandria-ui-elements/src/displays/components/SelectorMenu";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiSelectorRadioBox from "alexandria-ui-elements/src/displays/components/SelectorRadioBox";
import UiSelectorToggleBox from "alexandria-ui-elements/src/displays/components/SelectorToggleBox";
import UiSelectorCheckBox from "alexandria-ui-elements/src/displays/components/SelectorCheckBox";
import UiSelectorCollectionBox from "alexandria-ui-elements/src/displays/components/SelectorCollectionBox";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import DisplaysSelector8ListMold from "ui-elements/gen/displays/items/Selector8ListMold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import SelectorExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import SelectorExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class SelectorExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new SelectorExamplesMoldNotifier(this);
		this.requester = new SelectorExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_1293759108" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_1293759108.a1366869238" format="h6" mode="normal" value="Tabs facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_1293759108.a_1294821165" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorTabs context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_1293759108.a_1294821165.a_306608826" multipleSelection={false}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_1293759108.a_1294821165.a_306608826.a_685079136" name="tabOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_1293759108.a_1294821165.a_306608826.a_685079135" name="tabOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_1293759108.a_1294821165.a_306608826.a_685079134" name="tabOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorTabs>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_1293759108.a_1821531243" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_1293759108.a_1821531243.a1514454319" mode="normal" language="Html" value="Selector as Tabs&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) tabOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) tabOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) tabOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a986876463" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a986876463.a1057043617" format="h6" mode="normal" value="Menu facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a986876463.a_960018640" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorMenu context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a986876463.a_960018640.a1722381804" multipleSelection={false} layout="Vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a986876463.a_960018640.a1722381804.a1564631594" name="menuOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a986876463.a_960018640.a1722381804.a1564631595" name="menuOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a986876463.a_960018640.a1722381804.a1564631596" name="menuOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorMenu>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a986876463.a1580392087" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a986876463.a1580392087.a1687355187" mode="normal" language="Html" value="Selector as Menu(layout=Vertical)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) menuOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) menuOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) menuOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_995125558" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_995125558.a_271137398" format="h6" mode="normal" value="ComboBox facet with Traceable (cookie is used)">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_995125558.a1726698714" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_995125558.a1726698714.a1884876583" traceable={true} multipleSelection={false} maxMenuHeight={300}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_995125558.a1726698714.a1884876583.a578658599" name="comboBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_995125558.a1726698714.a1884876583.a578658600" name="comboBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_995125558.a1726698714.a1884876583.a578658601" name="comboBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorComboBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_995125558.a752729033" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1639840636.a_995125558.a752729033.a_2056591902" mode="normal" language="Html" value="Selector as ComboBox Traceable&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) comboBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) comboBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) comboBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1081949325" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1081949325.a2051416510" format="h6" mode="normal" value="ListBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1081949325.a349746209" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1081949325.a349746209.a_674503090" multipleSelection={false}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1081949325.a349746209.a_674503090.a1907218272" name="listBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1081949325.a349746209.a_674503090.a1907218273" name="listBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1081949325.a349746209.a_674503090.a1907218274" name="listBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorListBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1081949325.a1092920345" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1081949325.a1092920345.a1299854182" mode="normal" language="Html" value="Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) listBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) listBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) listBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1284439649" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1284439649.a_997597220" format="h6" mode="normal" value="RadioBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1284439649.a550762768" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorRadioBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1284439649.a550762768.a_512008311" multipleSelection={false} selected="radioBoxOption1" layout="Vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1284439649.a550762768.a_512008311.a_20870218" name="radioBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1284439649.a550762768.a_512008311.a_20870217" name="radioBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1284439649.a550762768.a_512008311.a_20870216" name="radioBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorRadioBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1284439649.a1590826278" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1284439649.a1590826278.a1913179082" mode="normal" language="Html" value="Selector as RadioBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) radioBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) radioBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) radioBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1197041883" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1197041883.a2032084676" format="h6" mode="normal" value="ToggleBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1197041883.a748090224" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorToggleBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1197041883.a748090224.a_349513532" multipleSelection={false} selected="toggleBoxOption1" layout="Horizontal" size="Medium">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1197041883.a748090224.a_349513532.a584957600" name="toggleBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1197041883.a748090224.a_349513532.a584957601" name="toggleBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1197041883.a748090224.a_349513532.a584957602" name="toggleBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorToggleBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1197041883.a_321850824" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120040231.a_1197041883.a_321850824.a_1264162075" mode="normal" language="Html" value="Selector as ToggleBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) toggleBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) toggleBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) toggleBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646385285" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646385285.a582834827" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646385285.a582834827.a_1339920702" format="h6" mode="normal" value="CheckBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646385285.a582834827.a1818360700" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorCheckBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646385285.a582834827.a1818360700.a_765731418" multipleSelection={false} layout="Vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646385285.a582834827.a1818360700.a_765731418.a1142936736" name="checkBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646385285.a582834827.a1818360700.a_765731418.a1142936737" name="checkBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646385285.a582834827.a1818360700.a_765731418.a1142936738" name="checkBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorCheckBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646385285.a582834827.a1519698825" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646385285.a582834827.a1519698825.a536877441" mode="normal" language="Html" value="Selector as CheckBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) checkBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) checkBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) checkBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646385285.a_1482949452" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646385285.a_1482949452.a643821919" format="h6" mode="normal" value="CollectionBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646385285.a_1482949452.a283550653" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorCollectionBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646385285.a_1482949452.a283550653.a_603236639" multipleSelection={false} allowOther="true">
								<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646385285.a_1482949452.a283550653.a_603236639.a1797190553selector8" pageSize={20} itemHeight={30} scrollingMark={true} selection="single">
								</UiList>
							</UiSelectorCollectionBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646385285.a_1482949452.a1745665930" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646385285.a_1482949452.a1745665930.a1740615180" mode="normal" language="Html" value="Selector as CollectionBox(allowOther=true)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) checkBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) checkBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) checkBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(SelectorExamplesMold));
DisplayFactory.register("SelectorExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(SelectorExamplesMold)));