import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenPage from "alexandria-ui-elements/src/displays/components/OpenPage";
import DisplaysWidgetMold from "ui-elements/gen/displays/templates/WidgetMold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import WidgetTypeTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import WidgetTypeTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class WidgetTypeTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new WidgetTypeTemplateNotifier(this);
		this.requester = new WidgetTypeTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a387219386" format="air" color="white" position="relative" width="-1px" height="100px" elevation={4}>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a387219386.a_2072180970" layout="horizontal center" spacing="24">
						<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a387219386.a_2072180970.a149265222" width="80px" height="80px">
						</UiImage>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a387219386.a_2072180970.a_607116561" format="h3" mode="normal" value="intino">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a387219386.a_2072180970.a790298661" format="headerToolbar" layout="horizontal center" spacing="24">
							<UiOpenPage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a387219386.a_2072180970.a790298661.a_1905229015" title="home" target="self" mode="Link" size="Medium">
							</UiOpenPage>
							<UiOpenPage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a387219386.a_2072180970.a790298661.a509211357" title="docs" target="self" mode="Link" size="Medium">
							</UiOpenPage>
						</UiBlock>
					</UiBlock>
				</UiHeader>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1520749005" format="containerAirLarge" layout="vertical">
					<DisplaysWidgetMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1520749005.a_621978645">
					</DisplaysWidgetMold>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(WidgetTypeTemplate));
DisplayFactory.register("WidgetTypeTemplate", withStyles(styles, { withTheme: true })(withSnackbar(WidgetTypeTemplate)));