import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenPage from "alexandria-ui-elements/src/displays/components/OpenPage";
import UiBlockParallax from "alexandria-ui-elements/src/displays/components/BlockParallax";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import HomeTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import HomeTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class HomeTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new HomeTemplateNotifier(this);
		this.requester = new HomeTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1278662049" format="air" color="white" position="relative" width="-1px" height="100px" elevation={4}>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1278662049.a_455539860" layout="horizontal center" spacing="24">
						<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1278662049.a_455539860.a_241920662" width="80px" height="80px">
						</UiImage>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1278662049.a_455539860.a_998302445" format="h3" mode="normal" value="intino">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1278662049.a_455539860.a629331577" format="headerToolbar" layout="horizontal center" spacing="24">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1278662049.a_455539860.a629331577.a_235515158" mode="normal" value="home">
							</UiText>
							<UiOpenPage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1278662049.a_455539860.a629331577.a8086926" title="docs" target="self" mode="Link" size="Medium">
							</UiOpenPage>
						</UiBlock>
					</UiBlock>
				</UiHeader>
				<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1602543363" format="containerAirLarge" layout="vertical" width="-1px" height="500px">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1602543363.a_355003673" layout="vertical center" width="70.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1602543363.a_355003673.a1779295285" format="h1 textCentered" mode="normal" value="software production lines made easy">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1602543363.a_355003673.a_520997746" format="h2" mode="normal" value="symplifying software mass customization">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1602543363.a_355003673.a1796507526" layout="horizontal">
						</UiBlock>
					</UiBlock>
				</UiBlockParallax>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_208312290" format="containerAirLarge" layout="vertical">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_208312290.a_968136673" layout="vertical center" width="70.0%" height="100.0%" spacing="40">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_208312290.a_968136673.a233324679" layout="vertical">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_208312290.a_968136673.a233324679.a1722466602" format="h1 air" mode="normal" value="Why intino?">
							</UiText>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_208312290.a_968136673.a_2063633392" layout="horizontal centercenter" width="-1px" height="300px" spacing="40">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_208312290.a_968136673.a_2063633392.a330507834" layout="vertical" width="28.0%" height="100.0%" paper>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_208312290.a_968136673.a_2063633392.a330507834.a840976426" format="h5 cardTitle" mode="normal" value="flexibility">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_208312290.a_968136673.a_2063633392.a330507834.a_1612884114" format="h5 cardContent" mode="normal" value="Extending benefits beyond software development into modifiability. With intino, software evolution is tailor-made, that is evolving systems built specifically for the needs of particular customer">
								</UiText>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_208312290.a_968136673.a_2063633392.a2093087865" layout="vertical" width="28.0%" height="100.0%" paper>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_208312290.a_968136673.a_2063633392.a2093087865.a_865102682" format="h5 cardTitle" mode="normal" value="reuse">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_208312290.a_968136673.a_2063633392.a2093087865.a1659497894" format="h5 cardContent" mode="normal" value="Developing core components that can be reused. This is the strategy that creates an opportunity for benefits in reducing the effort and costs costs required to create, deploy and software">
								</UiText>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_208312290.a_968136673.a_2063633392.a_1494349416" layout="vertical" width="28.0%" height="100.0%" paper>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_208312290.a_968136673.a_2063633392.a_1494349416.a635370744" format="h5 cardTitle" mode="normal" value="quality">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_208312290.a_968136673.a_2063633392.a_1494349416.a1883802575" format="h5 cardContent" mode="normal" value="Lowering the complexity of product line development. Application developers can focus on user requirements, getting advantage on the platform architecture that provides a stable quality">
								</UiText>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_35759985" format="containerAirLarge" layout="vertical" width="-1px" height="500px">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_35759985.a443352466" layout="vertical center" width="70.0%" height="100.0%" spacing="40">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_35759985.a443352466.a549405525" layout="vertical">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_35759985.a443352466.a549405525.a2008243244" format="h2 air white" mode="normal" value="What does it look like?">
							</UiText>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_35759985.a443352466.a_383861401" layout="horizontal">
						</UiBlock>
					</UiBlock>
				</UiBlockParallax>
				<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_563250419" format="containerAirLarge" layout="vertical" width="-1px" height="500px">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_563250419.a_660116363" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_563250419.a_660116363.a_1786040293" format="h1" mode="normal" value="software production lines made easy">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_563250419.a_660116363.a1255125974" format="h2" mode="normal" value="symplifying software mass customization">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_563250419.a_660116363.a_722336050" layout="horizontal">
						</UiBlock>
					</UiBlock>
				</UiBlockParallax>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(HomeTemplate));
DisplayFactory.register("HomeTemplate", withStyles(styles, { withTheme: true })(withSnackbar(HomeTemplate)));