import ActionableNotifier from "./ActionableNotifier"

export default class ActionSwitchNotifier extends ActionableNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refreshState").toSelf().execute((parameters) => this.element.refreshState(parameters.v));
		this.pushLinked = true;
	};
}