import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Table11MoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import Table11MoldRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Table11Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Table11MoldNotifier(this);
		this.requester = new Table11MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_681316466" mode="normal" placeholder="">
				</UiTextEditable>
			</div>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(Table11Mold));
DisplayFactory.register("Table11Mold", withStyles(styles, { withTheme: true })(withSnackbar(Table11Mold)));