import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSlider from "alexandria-ui-elements/src/displays/components/Slider";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemporalSlider from "alexandria-ui-elements/src/displays/components/TemporalSlider";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import SliderExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import SliderExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class SliderExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new SliderExamplesMoldNotifier(this);
		this.requester = new SliderExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a_1775658525" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a_1775658525.a1815546668" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a_1775658525.a_421105418" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a_1775658525.a_421105418.a_60326974" format="containerAirLarge" arrangement="Horizontal" range={{min:1,max:100}}>
							</UiSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a_1775658525.a1282783964" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a_1775658525.a1282783964.a_1005512901" mode="normal" language="Html" value="Slider slider&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a880218824" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a880218824.a_1952860027" format="h6" mode="normal" value="No facets with Animation property">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a880218824.a_599239633" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a880218824.a_599239633.a769820324" format="containerAirLarge" arrangement="Horizontal" animation={{interval:3000,loop:true}} range={{min:1,max:100}}>
							</UiSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a880218824.a_699129946" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a880218824.a_699129946.a240756858" mode="normal" language="Html" value="Slider slider&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Animation(interval=100 Millis, loop=true)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a1805164910" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a1805164910.a1553274767" format="h6" mode="normal" value="Temporal facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a1805164910.a710921648" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiTemporalSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a1805164910.a710921648.a_1993935096" format="containerAirLarge" arrangement="Horizontal">
							</UiTemporalSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a1805164910.a1402071901" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567374823.a1805164910.a1402071901.a536479189" mode="normal" language="Html" value="TemporalSlider slider&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;scales=Day Month Year">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_114255317" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_114255317.a_2119988324" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_114255317.a_2119988324.a630234487" format="h6" mode="normal" value="No facets with ToolbarOnly style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_114255317.a_2119988324.a_998720897" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_114255317.a_2119988324.a_998720897.a1157068483" format="containerAirLarge" arrangement="Horizontal" style="ToolbarOnly" range={{min:1,max:100}}>
							</UiSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_114255317.a_2119988324.a1776549421" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_114255317.a_2119988324.a1776549421.a1223201922" mode="normal" language="Html" value="Slider(style=ToolbarOnly)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_114255317.a_583519324" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_114255317.a_583519324.a549645887" format="h6" mode="normal" value="No facets with SliderOnly style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_114255317.a_583519324.a224684472" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_114255317.a_583519324.a224684472.a1987215781" format="containerAirLarge" arrangement="Horizontal" style="SliderOnly" range={{min:1,max:100}}>
							</UiSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_114255317.a_583519324.a1764607212" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_114255317.a_583519324.a1764607212.a131344030" mode="normal" language="Html" value="Slider(style=SliderOnly)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(SliderExamplesMold));
DisplayFactory.register("SliderExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(SliderExamplesMold)));