import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import DisplaysMultiple2Template from "ui-elements/gen/displays/templates/Multiple2Template";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import MultipleExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import MultipleExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class MultipleExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new MultipleExamplesMoldNotifier(this);
		this.requester = new MultipleExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a_400153351" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a_400153351.a_518700325" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a_400153351.a1709711481" format="filled" layout="vertical" spacing="8">
							<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a_400153351.a1709711481.a_1558470940" multiple={{instances:"multiple1",arrangement:"Vertical",noItemsMessage:"No elements found",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}} mode="normal">
							</UiMultiple>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a_400153351.a1709711481.a_1815087418" layout="vertical">
								<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a_400153351.a1709711481.a_1815087418.a1475925300" multiple={{instances:"multiple1Code",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}} mode="normal" value="Text as Multiple<br/>">
								</UiMultiple>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a46241118" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a46241118.a_1020127059" format="h6" mode="normal" value="No facets with collapsed">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a46241118.a_172385608" format="filled" layout="vertical" spacing="8">
							<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a46241118.a_172385608.a_641815717" multiple={{instances:"multiple2",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:true,count:{min:0,max:-1}}}>
							</UiMultiple>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a46241118.a_172385608.a_1156414114" layout="vertical">
								<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a46241118.a_172385608.a_1156414114.a479776468" multiple={{instances:"multiple2Code",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}} mode="normal" value="TemplateStamp(template=multiple2Template) multiple2 as Multiple(collapsed=true)</br>
								Template multiple2Template
									Text field1 as Editable">
								</UiMultiple>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(MultipleExamplesMold));
DisplayFactory.register("MultipleExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(MultipleExamplesMold)));