import BaseNumberNotifier from "./BaseNumberNotifier"

export default class NumberEditableNotifier extends BaseNumberNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refreshReadonly").toSelf().execute((parameters) => this.element.refreshReadonly(parameters.v));
		this.pushLinked = true;
	};
}