import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class ActionableNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refresh").toSelf().execute((parameters) => this.element.refresh(parameters.v));
		this.when("refreshReadonly").toSelf().execute((parameters) => this.element.refreshReadonly(parameters.v));
		this.when("refreshIcon").toSelf().execute((parameters) => this.element.refreshIcon(parameters.v));
		this.when("refreshAffirmed").toSelf().execute((parameters) => this.element.refreshAffirmed(parameters.v));
		this.when("refreshAffirmedRequired").toSelf().execute((parameters) => this.element.refreshAffirmedRequired(parameters.v));
		this.when("checkSignResult").toSelf().execute((parameters) => this.element.checkSignResult(parameters.v));
		this.pushLinked = true;
	};
}