import PageCollectionNotifier from "./PageCollectionNotifier"

export default class DynamicTableNotifier extends PageCollectionNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("setup").toSelf().execute((parameters) => this.element.setup(parameters.v));
		this.when("sections").toSelf().execute((parameters) => this.element.sections(parameters.v));
		this.when("selectRowProvided").toSelf().execute((parameters) => this.element.selectRowProvided(parameters.v));
		this.when("openRow").toSelf().execute((parameters) => this.element.openRow(parameters.v));
		this.when("refreshZeros").toSelf().execute((parameters) => this.element.refreshZeros(parameters.v));
		this.when("refreshPercentages").toSelf().execute((parameters) => this.element.refreshPercentages(parameters.v));
		this.when("refreshVisibleColumns").toSelf().execute((parameters) => this.element.refreshVisibleColumns(parameters.v));
		this.pushLinked = true;
	};
}