import BaseTextRequester from "./BaseTextRequester"

export default class TextEditableRequester extends BaseTextRequester {
	constructor(element) {
		super(element);
	};
	notifyChange = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "notifyChange", s: "texteditable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	notifyKeyPress = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "notifyKeyPress", s: "texteditable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "texteditable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}