import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenPage from "alexandria-ui-elements/src/displays/components/OpenPage";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import DisplaysWidgetSummaryMold from "ui-elements/gen/displays/templates/WidgetSummaryMold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DocsTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import DocsTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DocsTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DocsTemplateNotifier(this);
		this.requester = new DocsTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1207447471" format="air" color="white" position="relative" width="-1px" height="100px" elevation={4}>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1207447471.a_838708836" layout="horizontal center" spacing="24">
						<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1207447471.a_838708836.a_942684802" width="80px" height="80px">
						</UiImage>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1207447471.a_838708836.a_1319856012" format="h3" mode="normal" value="intino">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1207447471.a_838708836.a_433533055" format="headerToolbar" layout="horizontal center" spacing="24">
							<UiOpenPage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1207447471.a_838708836.a_433533055.a_345371218" title="home" target="self" mode="Link" size="Medium">
							</UiOpenPage>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1207447471.a_838708836.a_433533055.a_833553558" mode="normal" value="docs">
							</UiText>
						</UiBlock>
					</UiBlock>
				</UiHeader>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251" format="containerAirLarge" layout="wrap" spacing="40">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251.a_149344623" label="data widgets" format="h5 paperFormat" layout="vertical" spacing="8">
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251.a_149344623.a_1887322377" multiple={{instances:"dataWidgets",arrangement:"Horizontal",noItemsMessage:"no widgets",spacing:16,editable:false,wrap:true,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251.a_1376863834" label="catalog widgets" format="h5 paperFormat" layout="vertical" spacing="8">
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251.a_1376863834.a1972960271" multiple={{instances:"catalogWidgets",arrangement:"Horizontal",noItemsMessage:"no widgets",spacing:16,editable:false,wrap:true,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251.a1885192344" label="operation widgets" format="h5 paperFormat" layout="vertical" spacing="8">
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251.a1885192344.a1764951055" multiple={{instances:"operationWidgets",arrangement:"Horizontal",noItemsMessage:"no widgets",spacing:16,editable:false,wrap:true,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251.a_1326767729" label="other widgets" format="h5 paperFormat" layout="vertical" spacing="8">
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251.a_1326767729.a693468719" multiple={{instances:"otherWidgets",arrangement:"Horizontal",noItemsMessage:"no widgets",spacing:16,editable:false,wrap:true,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(DocsTemplate));
DisplayFactory.register("DocsTemplate", withStyles(styles, { withTheme: true })(withSnackbar(DocsTemplate)));