import BaseImageRequester from "./BaseImageRequester"

export default class ImageEditableRequester extends BaseImageRequester {
	constructor(element) {
		super(element);
	};
	notifyChange = (value) => {
	    if (this.addToHistory(value)) return;
	    this.fileService.upload({ op: "notifyChange", s: "imageeditable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: value}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "imageeditable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}