/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.triplestore;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.triplestore.TripleStore;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class MemoryTripleStore
implements TripleStore {
    private final List<String[]> triples;

    public MemoryTripleStore() {
        this.triples = new ArrayList<String[]>();
    }

    public MemoryTripleStore(InputStream is) {
        this.triples = this.contentOf(is).map(this::triple).collect(Collectors.toList());
    }

    private static String[] valuePatternOf(String[] triple) {
        return new String[]{triple[0], triple[1], null};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Stream<String> contentOf(InputStream is) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            Stream<String> stream = reader.lines().collect(Collectors.toList()).stream();
            return stream;
        }
        catch (IOException e) {
            Logger.error((String)e.getMessage(), (Throwable)e);
            return Stream.empty();
        }
    }

    @Override
    public Stream<String[]> all() {
        return this.triples.stream();
    }

    @Override
    public Stream<String[]> matches(String ... pattern) {
        return StreamSupport.stream(this.find(this.normalize(pattern)).spliterator(), false).map(this.triples::get);
    }

    @Override
    public synchronized void put(String subject, String predicate, Object value) {
        this.put(subject, predicate, value.toString());
    }

    public synchronized void save(OutputStream outputStream) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));){
            for (String[] triple : this.triples) {
                writer.write(TripleStore.lineOf(triple));
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void put(String ... triple) {
        this.find(MemoryTripleStore.valuePatternOf(triple)).forEach(this::remove);
        this.triples.add(triple);
    }

    private void remove(int index) {
        this.triples.remove(index);
    }

    private String[] normalize(String[] pattern) {
        String[] result = new String[]{null, null, null};
        System.arraycopy(pattern, 0, result, 0, pattern.length);
        return result;
    }

    private Iterable<Integer> find(final String[] pattern) {
        return () -> new Iterator<Integer>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                while (this.index < MemoryTripleStore.this.triples.size() && !this.match((String[])MemoryTripleStore.this.triples.get(this.index))) {
                    ++this.index;
                }
                return this.index < MemoryTripleStore.this.triples.size();
            }

            private boolean match(String[] triple) {
                return IntStream.range(0, 3).allMatch(this.with(triple));
            }

            private IntPredicate with(String[] triple) {
                return i -> pattern[i] == null || pattern[i].equals(triple[i]);
            }

            @Override
            public Integer next() {
                return this.index++;
            }
        };
    }

    private String[] triple(String line) {
        return line.split(";");
    }
}

