/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.totp;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import de.taimos.totp.TOTP;
import io.intino.alexandria.logger.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Hex;

public class Totp {
    private static final String OneTimePasswordBarCode = "otpauth://totp/$company$%3A$email$?secret=$secret$&issuer=$company$";

    public static String secret() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        Base32 base32 = new Base32();
        return base32.encodeToString(bytes);
    }

    public static byte[] image(String secret, String email, String company) {
        byte[] byArray;
        String barCodeData = OneTimePasswordBarCode.replace("$company$", company != null ? company : "Company");
        barCodeData = barCodeData.replace("$email$", email != null ? email : "info@company.com");
        barCodeData = barCodeData.replace("$secret$", secret);
        BitMatrix matrix = new MultiFormatWriter().encode(barCodeData, BarcodeFormat.QR_CODE, 200, 200);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"png", (OutputStream)out);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.error((Throwable)e);
                    return null;
                }
            }
            catch (WriterException e) {
                Logger.error((Throwable)e);
                return null;
            }
        }
        out.close();
        return byArray;
    }

    public static boolean check(String secret, String sixDigitCode) {
        if (secret == null) {
            return false;
        }
        Base32 base32 = new Base32();
        byte[] bytes = base32.decode(secret);
        String hexKey = Hex.encodeHexString((byte[])bytes);
        return TOTP.getOTP((String)hexKey).equals(sixDigitCode);
    }
}

