/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.terminal.remotedatalake.resource;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.event.resource.ResourceEvent;
import io.intino.alexandria.terminal.remotedatalake.DatalakeAccessor;
import io.intino.alexandria.terminal.remotedatalake.resource.RemoteResourceTub;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RemoteResourceSource
implements Datalake.Store.Source<ResourceEvent> {
    private final DatalakeAccessor accessor;
    private final String tank;
    private final String source;
    private final List<String> tubs;

    public RemoteResourceSource(DatalakeAccessor accessor, String tank, JsonObject source) {
        this.accessor = accessor;
        this.tank = tank;
        this.source = source.get("name").getAsString();
        this.tubs = source.get("tubs").getAsJsonArray().asList().stream().map(JsonElement::getAsString).collect(Collectors.toList());
    }

    public String name() {
        return this.source;
    }

    public Stream<Datalake.Store.Tub<ResourceEvent>> tubs() {
        return this.tubs.stream().map(t -> new RemoteResourceTub(this.accessor, this.tank, this.source, (String)t));
    }

    public Datalake.Store.Tub<ResourceEvent> first() {
        if (!this.tubs.isEmpty()) {
            return new RemoteResourceTub(this.accessor, this.tank, this.source, this.tubs.get(0));
        }
        return null;
    }

    public Datalake.Store.Tub<ResourceEvent> last() {
        return !this.tubs.isEmpty() ? new RemoteResourceTub(this.accessor, this.tank, this.source, this.tubs.get(this.tubs.size() - 1)) : null;
    }

    public Datalake.Store.Tub<ResourceEvent> on(Timetag timetag) {
        return this.tubs().filter(t -> t.timetag().equals((Object)timetag)).findFirst().orElse(null);
    }
}

