/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.terminal;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.jms.ConnectionConfig;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.terminal.Connector;
import io.intino.alexandria.terminal.EventOutBox;
import io.intino.alexandria.terminal.MessageOutBox;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageNotWriteableException;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQTextMessage;

public class StubConnector
implements Connector {
    private final Map<String, List<Consumer<Event>>> eventConsumers;
    private final Map<String, List<Connector.MessageConsumer>> messageConsumers;
    private final ConnectionConfig config;
    private final Map<String, String> urlParameters;
    private EventOutBox eventOutBox;
    private MessageOutBox messageOutBox;

    public StubConnector(ConnectionConfig config, File outBoxDirectory) {
        this.config = config;
        this.urlParameters = this.parameters(config.url());
        this.eventConsumers = new HashMap<String, List<Consumer<Event>>>();
        this.messageConsumers = new HashMap<String, List<Connector.MessageConsumer>>();
        if (outBoxDirectory != null) {
            this.eventOutBox = new EventOutBox(new File(outBoxDirectory, "events"));
            this.messageOutBox = new MessageOutBox(new File(outBoxDirectory, "requests"));
        }
    }

    @Override
    public String clientId() {
        return "mock-client";
    }

    public void start() {
    }

    @Override
    public synchronized void sendEvent(String path, Event event) {
        ArrayList consumers = new ArrayList(this.eventConsumers.getOrDefault(path, Collections.emptyList()));
        for (Consumer c : consumers) {
            c.accept(event);
        }
        if (this.eventOutBox != null) {
            this.eventOutBox.push(path, event);
        }
    }

    @Override
    public synchronized void sendEvents(String path, List<Event> events) {
        ArrayList<Consumer> consumers = new ArrayList<Consumer>(this.eventConsumers.getOrDefault(path, Collections.emptyList()));
        consumers.forEach(events::forEach);
        if (this.eventOutBox != null) {
            events.forEach(e -> this.eventOutBox.push(path, (Event)e));
        }
    }

    @Override
    public synchronized void sendEvents(String path, List<Event> events, int expirationInSeconds) {
        this.sendEvents(path, events);
    }

    @Override
    public synchronized void sendEvent(String path, Event event, int expirationInSeconds) {
        this.sendEvent(path, event);
    }

    @Override
    public void attachListener(String path, Consumer<Event> onEventReceived) {
        this.registerEventConsumer(path, onEventReceived);
    }

    @Override
    public void attachListener(String path, Consumer<Event> onEventReceived, String messageSelector) {
        this.registerEventConsumer(path, onEventReceived);
    }

    @Override
    public void sendQueueMessage(String path, String message) {
        if (this.messageOutBox != null) {
            this.messageOutBox.push(path, message);
        }
    }

    @Override
    public void sendTopicMessage(String path, String message) {
        if (this.messageOutBox != null) {
            this.messageOutBox.push(path, message);
        }
    }

    @Override
    public void attachListener(String path, String subscriberId, Consumer<Event> onEventReceived) {
        this.registerEventConsumer(path, onEventReceived);
    }

    @Override
    public void attachListener(String path, String subscriberId, Consumer<Event> onEventReceived, Predicate<Instant> filter, String messageSelector) {
        this.registerEventConsumer(path, onEventReceived);
    }

    @Override
    public void attachListener(String path, String subscriberId, Consumer<Event> onEventReceived, String messageSelector) {
        this.registerEventConsumer(path, onEventReceived);
    }

    @Override
    public void attachListener(String path, Connector.MessageConsumer onMessageReceived) {
        this.registerMessageConsumer(path, onMessageReceived);
    }

    @Override
    public void attachListener(String path, String subscriberId, Connector.MessageConsumer onMessageReceived) {
        this.registerMessageConsumer(path, onMessageReceived);
    }

    @Override
    public void detachListeners(Consumer<Event> consumer) {
        this.eventConsumers.values().forEach(list -> list.remove(consumer));
    }

    @Override
    public void detachListeners(Connector.MessageConsumer consumer) {
        this.messageConsumers.values().forEach(list -> list.remove(consumer));
    }

    @Override
    public void createSubscription(String path, String subscriberId) {
    }

    @Override
    public void destroySubscription(String subscriberId) {
    }

    @Override
    public void detachListeners(String path) {
        this.eventConsumers.get(path).clear();
        this.messageConsumers.get(path).clear();
    }

    @Override
    public Message requestResponse(String path, Message message) {
        return null;
    }

    @Override
    public Message requestResponse(String path, Message message, long timeout, TimeUnit timeUnit) {
        return path.equals("service.ness.datalake") && this.isDatalakeRequest(message) ? this.datalakeArgument() : null;
    }

    private Message datalakeArgument() {
        try {
            String datalake = this.urlParameters.get("datalake");
            if (datalake == null) {
                return null;
            }
            this.createDirectoryIfNotExists(datalake);
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            message.setText(datalake);
            return message;
        }
        catch (MessageNotWriteableException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private void createDirectoryIfNotExists(String datalake) {
        try {
            new File(datalake).mkdirs();
        }
        catch (Exception e) {
            Logger.error((String)("Could not create directory " + datalake + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private Map<String, String> parameters(String url) {
        if (!url.contains("?")) {
            return Map.of();
        }
        String substring = url.substring(url.indexOf("?") + 1);
        return Arrays.stream(substring.split(";")).collect(Collectors.toMap(p -> p.split("=")[0], p -> p.split("=")[1]));
    }

    private boolean isDatalakeRequest(Message message) {
        if (!(message instanceof TextMessage)) {
            return false;
        }
        try {
            String text = ((TextMessage)message).getText();
            return text.startsWith("[Datalake]");
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    @Override
    public void requestResponse(String path, Message message, String responsePath) {
    }

    @Override
    public long defaultTimeoutAmount() {
        return 0L;
    }

    @Override
    public TimeUnit defaultTimeoutUnit() {
        return TimeUnit.SECONDS;
    }

    public void stop() {
    }

    private void registerEventConsumer(String path, Consumer<Event> onEventReceived) {
        this.eventConsumers.putIfAbsent(path, new CopyOnWriteArrayList());
        this.eventConsumers.get(path).add(onEventReceived);
    }

    private void registerMessageConsumer(String path, Connector.MessageConsumer onMessageReceived) {
        this.messageConsumers.putIfAbsent(path, new CopyOnWriteArrayList());
        this.messageConsumers.get(path).add(onMessageReceived);
    }
}

