/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.terminal;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.terminal.OutBox;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;

class MessageOutBox
extends OutBox {
    private static final String JSON = ".json";

    MessageOutBox(File directory) {
        super(directory);
    }

    Map.Entry<String, String> get() {
        this.files.sort(Comparator.comparingLong(File::lastModified));
        if (this.files.isEmpty()) {
            return null;
        }
        try {
            File file = (File)this.files.get(0);
            if (!file.exists()) {
                this.files.remove(file);
                return null;
            }
            String content = Files.readString(file.toPath());
            if (content.isEmpty() || content.isBlank()) {
                return null;
            }
            return new AbstractMap.SimpleEntry<String, String>(this.destination(file), content);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    void push(String path, String message) {
        try {
            File file = new File(this.directory, path + "#" + UUID.randomUUID().toString() + JSON);
            Files.write(file.toPath(), message.getBytes(), new OpenOption[0]);
            this.files.add(file);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    @Override
    protected String extension() {
        return JSON;
    }

    @Override
    protected String destination(File file) {
        return file.getName().substring(0, file.getName().indexOf("#"));
    }
}

