/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.sqlpredicate.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class SimpleCharStream {
    public static final boolean staticFlag = false;
    int bufSize;
    int available;
    int tokenBegin;
    public int bufPos = -1;
    protected int[] bufLine;
    protected int[] bufColumn;
    protected int column;
    protected int line;
    protected boolean prevCharIsCR = false;
    protected boolean prevCharIsLF = false;
    protected Reader inputStream;
    protected char[] buffer;
    protected int maxNextCharInd = 0;
    protected int inBuf = 0;
    protected int tabSize = 1;

    protected void expandBuff(boolean wrapAround) {
        char[] newBuffer = new char[this.bufSize + 2048];
        int[] newBufLine = new int[this.bufSize + 2048];
        int[] newBufColumn = new int[this.bufSize + 2048];
        try {
            if (wrapAround) {
                System.arraycopy(this.buffer, this.tokenBegin, newBuffer, 0, this.bufSize - this.tokenBegin);
                System.arraycopy(this.buffer, 0, newBuffer, this.bufSize - this.tokenBegin, this.bufPos);
                this.buffer = newBuffer;
                System.arraycopy(this.bufLine, this.tokenBegin, newBufLine, 0, this.bufSize - this.tokenBegin);
                System.arraycopy(this.bufLine, 0, newBufLine, this.bufSize - this.tokenBegin, this.bufPos);
                this.bufLine = newBufLine;
                System.arraycopy(this.bufColumn, this.tokenBegin, newBufColumn, 0, this.bufSize - this.tokenBegin);
                System.arraycopy(this.bufColumn, 0, newBufColumn, this.bufSize - this.tokenBegin, this.bufPos);
                this.bufColumn = newBufColumn;
                this.maxNextCharInd = this.bufPos += this.bufSize - this.tokenBegin;
            } else {
                System.arraycopy(this.buffer, this.tokenBegin, newBuffer, 0, this.bufSize - this.tokenBegin);
                this.buffer = newBuffer;
                System.arraycopy(this.bufLine, this.tokenBegin, newBufLine, 0, this.bufSize - this.tokenBegin);
                this.bufLine = newBufLine;
                System.arraycopy(this.bufColumn, this.tokenBegin, newBufColumn, 0, this.bufSize - this.tokenBegin);
                this.bufColumn = newBufColumn;
                this.maxNextCharInd = this.bufPos -= this.tokenBegin;
            }
        }
        catch (Throwable t) {
            throw new Error(t.getMessage());
        }
        this.bufSize += 2048;
        this.available = this.bufSize;
        this.tokenBegin = 0;
    }

    protected void FillBuff() throws IOException {
        if (this.maxNextCharInd == this.available) {
            if (this.available == this.bufSize) {
                if (this.tokenBegin > 2048) {
                    this.maxNextCharInd = 0;
                    this.bufPos = 0;
                    this.available = this.tokenBegin;
                } else if (this.tokenBegin < 0) {
                    this.maxNextCharInd = 0;
                    this.bufPos = 0;
                } else {
                    this.expandBuff(false);
                }
            } else if (this.available > this.tokenBegin) {
                this.available = this.bufSize;
            } else if (this.tokenBegin - this.available < 2048) {
                this.expandBuff(true);
            } else {
                this.available = this.tokenBegin;
            }
        }
        try {
            int i = this.inputStream.read(this.buffer, this.maxNextCharInd, this.available - this.maxNextCharInd);
            if (i == -1) {
                this.inputStream.close();
                throw new IOException();
            }
            this.maxNextCharInd += i;
        }
        catch (IOException e) {
            --this.bufPos;
            this.backup(0);
            if (this.tokenBegin == -1) {
                this.tokenBegin = this.bufPos;
            }
            throw e;
        }
    }

    public char BeginToken() throws IOException {
        this.tokenBegin = -1;
        char c = this.readChar();
        this.tokenBegin = this.bufPos;
        return c;
    }

    protected void UpdateLineColumn(char c) {
        ++this.column;
        if (this.prevCharIsLF) {
            this.prevCharIsLF = false;
            this.column = 1;
            ++this.line;
        } else if (this.prevCharIsCR) {
            this.prevCharIsCR = false;
            if (c == '\n') {
                this.prevCharIsLF = true;
            } else {
                this.column = 1;
                ++this.line;
            }
        }
        switch (c) {
            case '\r': {
                this.prevCharIsCR = true;
                break;
            }
            case '\n': {
                this.prevCharIsLF = true;
                break;
            }
            case '\t': {
                --this.column;
                this.column += this.tabSize - this.column % this.tabSize;
                break;
            }
        }
        this.bufLine[this.bufPos] = this.line;
        this.bufColumn[this.bufPos] = this.column;
    }

    public char readChar() throws IOException {
        if (this.inBuf > 0) {
            --this.inBuf;
            if (++this.bufPos == this.bufSize) {
                this.bufPos = 0;
            }
            return this.buffer[this.bufPos];
        }
        if (++this.bufPos >= this.maxNextCharInd) {
            this.FillBuff();
        }
        char c = this.buffer[this.bufPos];
        this.UpdateLineColumn(c);
        return c;
    }

    public int getEndColumn() {
        return this.bufColumn[this.bufPos];
    }

    public int getEndLine() {
        return this.bufLine[this.bufPos];
    }

    public int getBeginColumn() {
        return this.bufColumn[this.tokenBegin];
    }

    public int getBeginLine() {
        return this.bufLine[this.tokenBegin];
    }

    public void backup(int amount) {
        this.inBuf += amount;
        if ((this.bufPos -= amount) < 0) {
            this.bufPos += this.bufSize;
        }
    }

    public SimpleCharStream(Reader stream, int startLine, int startColumn, int bufferSize) {
        this.inputStream = stream;
        this.line = startLine;
        this.column = startColumn - 1;
        this.available = this.bufSize = bufferSize;
        this.buffer = new char[bufferSize];
        this.bufLine = new int[bufferSize];
        this.bufColumn = new int[bufferSize];
    }

    public SimpleCharStream(Reader stream, int startLine, int startColumn) {
        this(stream, startLine, startColumn, 4096);
    }

    public SimpleCharStream(Reader dstream) {
        this(dstream, 1, 1, 4096);
    }

    public void reInit(Reader dstream, int startline, int startcolumn, int buffersize) {
        this.inputStream = dstream;
        this.line = startline;
        this.column = startcolumn - 1;
        if (this.buffer == null || buffersize != this.buffer.length) {
            this.available = this.bufSize = buffersize;
            this.buffer = new char[buffersize];
            this.bufLine = new int[buffersize];
            this.bufColumn = new int[buffersize];
        }
        this.prevCharIsCR = false;
        this.prevCharIsLF = false;
        this.maxNextCharInd = 0;
        this.inBuf = 0;
        this.tokenBegin = 0;
        this.bufPos = -1;
    }

    public void reInit(Reader stream, int startLine, int startColumn) {
        this.reInit(stream, startLine, startColumn, 4096);
    }

    public void reInit(Reader stream) {
        this.reInit(stream, 1, 1, 4096);
    }

    public SimpleCharStream(InputStream stream, String encoding, int startLine, int startColumn, int bufferSize) throws UnsupportedEncodingException {
        this(encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding), startLine, startColumn, bufferSize);
    }

    public SimpleCharStream(InputStream stream, String encoding, int startline, int startColumn) throws UnsupportedEncodingException {
        this(stream, encoding, startline, startColumn, 4096);
    }

    public void reInit(InputStream stream, String encoding, int startLine, int startColumn, int bufferSize) throws UnsupportedEncodingException {
        this.reInit(encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding), startLine, startColumn, bufferSize);
    }

    public void reInit(InputStream stream, String encoding, int startLine, int startColumn) throws UnsupportedEncodingException {
        this.reInit(stream, encoding, startLine, startColumn, 4096);
    }

    public String getImage() {
        if (this.bufPos >= this.tokenBegin) {
            return new String(this.buffer, this.tokenBegin, this.bufPos - this.tokenBegin + 1);
        }
        return new String(this.buffer, this.tokenBegin, this.bufSize - this.tokenBegin) + new String(this.buffer, 0, this.bufPos + 1);
    }
}

