/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.sqlpredicate.expressions.functions;

import io.intino.alexandria.sqlpredicate.context.EvaluationContext;
import io.intino.alexandria.sqlpredicate.expressions.FunctionCallExpression;
import io.intino.alexandria.sqlpredicate.expressions.functions.FilterFunction;
import java.util.Arrays;

public class SplitFunction
implements FilterFunction {
    @Override
    public boolean isValid(FunctionCallExpression expr) {
        return expr.getNumArguments() >= 2 && expr.getNumArguments() <= 3;
    }

    @Override
    public boolean returnsBoolean(FunctionCallExpression expr) {
        return false;
    }

    @Override
    public Object evaluate(FunctionCallExpression expr, EvaluationContext context) throws Exception {
        String src = (String)expr.getArgument(0).evaluate(context);
        String splitPattern = (String)expr.getArgument(1).evaluate(context);
        String[] result = expr.getNumArguments() > 2 ? src.split(splitPattern, (Integer)expr.getArgument(2).evaluate(context)) : src.split(splitPattern);
        return Arrays.asList(result);
    }
}

