/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.sqlpredicate.expressions.functions;

import io.intino.alexandria.sqlpredicate.context.EvaluationContext;
import io.intino.alexandria.sqlpredicate.expressions.FunctionCallExpression;
import io.intino.alexandria.sqlpredicate.expressions.functions.FilterFunction;
import io.intino.alexandria.sqlpredicate.parser.LRUCache;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexMatchFunction
implements FilterFunction {
    protected static final LRUCache<String, Pattern> compiledExprCache = new LRUCache(100);

    @Override
    public boolean isValid(FunctionCallExpression expr) {
        return expr.getNumArguments() == 2;
    }

    @Override
    public boolean returnsBoolean(FunctionCallExpression expr) {
        return true;
    }

    @Override
    public Object evaluate(FunctionCallExpression expr, EvaluationContext context) throws Exception {
        Object reg = expr.getArgument(0).evaluate(context);
        if (reg != null) {
            String reg_str = reg instanceof String ? (String)reg : reg.toString();
            Object cand = expr.getArgument(1).evaluate(context);
            if (cand != null) {
                Pattern pat = this.getCompiledPattern(reg_str);
                Matcher matchEng = pat.matcher(cand instanceof String ? (String)cand : cand.toString());
                return matchEng.find();
            }
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pattern getCompiledPattern(String reg_ex_str) {
        Pattern result;
        LRUCache<String, Pattern> lRUCache = compiledExprCache;
        synchronized (lRUCache) {
            result = (Pattern)compiledExprCache.get(reg_ex_str);
        }
        if (result == null) {
            result = Pattern.compile(reg_ex_str);
            lRUCache = compiledExprCache;
            synchronized (lRUCache) {
                compiledExprCache.put(reg_ex_str, result);
            }
        }
        return result;
    }
}

