/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.sqlpredicate.expressions;

import io.intino.alexandria.sqlpredicate.context.EvaluationContext;
import io.intino.alexandria.sqlpredicate.expressions.BooleanExpression;
import java.util.ArrayList;
import java.util.List;

public abstract class LogicExpression
implements BooleanExpression {
    protected final List<BooleanExpression> expressions = new ArrayList<BooleanExpression>(2);

    private LogicExpression(BooleanExpression lvalue, BooleanExpression rvalue) {
        this.expressions.add(lvalue);
        this.expressions.add(rvalue);
    }

    protected void addExpression(BooleanExpression expression) {
        this.expressions.add(expression);
    }

    public BooleanExpression getLeft() {
        if (this.expressions.size() == 2) {
            return this.expressions.get(0);
        }
        throw new IllegalStateException("This expression is not binary: " + this);
    }

    public BooleanExpression getRight() {
        if (this.expressions.size() == 2) {
            return this.expressions.get(1);
        }
        throw new IllegalStateException("This expression is not binary: " + this);
    }

    public abstract String getExpressionSymbol();

    public String toString() {
        if (this.expressions.size() == 2) {
            return "( " + this.expressions.get(0) + " " + this.getExpressionSymbol() + " " + this.expressions.get(1) + " )";
        }
        StringBuilder result = new StringBuilder("(");
        int count = 0;
        for (BooleanExpression expression : this.expressions) {
            if (count++ > 0) {
                result.append(" ").append(this.getExpressionSymbol()).append(" ");
            }
            result.append(expression.toString());
        }
        result.append(")");
        return result.toString();
    }

    public static BooleanExpression createOR(BooleanExpression lvalue, BooleanExpression rvalue) {
        if (lvalue instanceof ORExpression) {
            ORExpression orExpression = (ORExpression)lvalue;
            orExpression.addExpression(rvalue);
            return orExpression;
        }
        return new ORExpression(lvalue, rvalue);
    }

    public static BooleanExpression createAND(BooleanExpression lvalue, BooleanExpression rvalue) {
        if (lvalue instanceof ANDExpression) {
            ANDExpression orExpression = (ANDExpression)lvalue;
            orExpression.addExpression(rvalue);
            return orExpression;
        }
        return new ANDExpression(lvalue, rvalue);
    }

    @Override
    public abstract Object evaluate(EvaluationContext var1) throws Exception;

    @Override
    public abstract boolean matches(EvaluationContext var1) throws Exception;

    public static class ORExpression
    extends LogicExpression {
        public ORExpression(BooleanExpression lvalue, BooleanExpression rvalue) {
            super(lvalue, rvalue);
        }

        @Override
        public Object evaluate(EvaluationContext context) throws Exception {
            boolean someNulls = false;
            for (BooleanExpression expression : this.expressions) {
                Boolean lv = (Boolean)expression.evaluate(context);
                if (lv != null && lv.booleanValue()) {
                    return Boolean.TRUE;
                }
                if (lv != null) continue;
                someNulls = true;
            }
            if (someNulls) {
                return null;
            }
            return Boolean.FALSE;
        }

        @Override
        public boolean matches(EvaluationContext context) throws Exception {
            for (BooleanExpression expression : this.expressions) {
                boolean lv = expression.matches(context);
                if (!lv) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getExpressionSymbol() {
            return "OR";
        }
    }

    private static class ANDExpression
    extends LogicExpression {
        public ANDExpression(BooleanExpression lvalue, BooleanExpression rvalue) {
            super(lvalue, rvalue);
        }

        @Override
        public Object evaluate(EvaluationContext context) throws Exception {
            boolean someNulls = false;
            for (BooleanExpression expression : this.expressions) {
                Boolean lv = (Boolean)expression.evaluate(context);
                if (lv != null && !lv.booleanValue()) {
                    return Boolean.FALSE;
                }
                if (lv != null) continue;
                someNulls = true;
            }
            if (someNulls) {
                return null;
            }
            return Boolean.TRUE;
        }

        @Override
        public boolean matches(EvaluationContext context) throws Exception {
            for (BooleanExpression expression : this.expressions) {
                boolean lv = expression.matches(context);
                if (lv) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getExpressionSymbol() {
            return "AND";
        }
    }
}

