/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.sqlpredicate.expressions;

import io.intino.alexandria.sqlpredicate.context.EvaluationContext;
import io.intino.alexandria.sqlpredicate.expressions.BooleanFunctionCallExpr;
import io.intino.alexandria.sqlpredicate.expressions.Expression;
import io.intino.alexandria.sqlpredicate.expressions.functions.BuiltinFunctionRegistry;
import io.intino.alexandria.sqlpredicate.expressions.functions.FilterFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FunctionCallExpression
implements Expression {
    protected static final HashMap<String, FunctionRegistration> functionRegistry = new HashMap();
    protected String functionName;
    protected ArrayList<Expression> arguments;
    protected FilterFunction function;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerFunction(String name, FilterFunction function) {
        boolean result = true;
        HashMap<String, FunctionRegistration> hashMap = functionRegistry;
        synchronized (hashMap) {
            if (functionRegistry.containsKey(name)) {
                result = false;
            } else {
                functionRegistry.put(name, new FunctionRegistration(function));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterFunction(String name) {
        HashMap<String, FunctionRegistration> hashMap = functionRegistry;
        synchronized (hashMap) {
            functionRegistry.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FunctionCallExpression(String function, List<Expression> args) throws InvalidFunctionExpressionException {
        FunctionRegistration funcReg;
        HashMap<String, FunctionRegistration> hashMap = functionRegistry;
        synchronized (hashMap) {
            funcReg = functionRegistry.get(function);
        }
        if (funcReg == null) {
            throw new InvalidFunctionExpressionException("invalid function name, \"" + function + "\"");
        }
        this.arguments = new ArrayList();
        this.arguments.addAll(args);
        this.functionName = function;
        this.function = funcReg.getFilterFunction();
    }

    public static FunctionCallExpression createFunctionCall(String func_name, List<Expression> args) throws InvalidFunctionExpressionException {
        FunctionCallExpression result = new FunctionCallExpression(func_name, args);
        if (result.function.isValid(result)) {
            if (result.function.returnsBoolean(result)) {
                result = new BooleanFunctionCallExpr(func_name, args);
            }
        } else {
            throw new InvalidFunctionExpressionException("invalid call of function " + func_name);
        }
        return result;
    }

    public int getNumArguments() {
        return this.arguments.size();
    }

    public Expression getArgument(int which) {
        return this.arguments.get(which);
    }

    @Override
    public Object evaluate(EvaluationContext context) throws Exception {
        return this.function.evaluate(this, context);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.functionName).append("(");
        boolean first_f = true;
        for (Expression arg : this.arguments) {
            if (first_f) {
                first_f = false;
            } else {
                result.append(", ");
            }
            result.append(arg.toString());
        }
        result.append(")");
        return result.toString();
    }

    static {
        BuiltinFunctionRegistry.register();
    }

    protected static class FunctionRegistration {
        protected FilterFunction filterFunction;

        public FunctionRegistration(FilterFunction func) {
            this.filterFunction = func;
        }

        public FilterFunction getFilterFunction() {
            return this.filterFunction;
        }
    }

    public static class InvalidFunctionExpressionException
    extends Exception {
        public InvalidFunctionExpressionException(String msg) {
            super(msg);
        }
    }
}

