/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.sqlpredicate;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.sqlpredicate.context.EvaluationContext;
import io.intino.alexandria.sqlpredicate.expressions.ArithmeticExpression;
import io.intino.alexandria.sqlpredicate.expressions.BooleanExpression;
import io.intino.alexandria.sqlpredicate.expressions.ComparisonExpression;
import io.intino.alexandria.sqlpredicate.expressions.ConstantExpression;
import io.intino.alexandria.sqlpredicate.expressions.Expression;
import io.intino.alexandria.sqlpredicate.expressions.FunctionCallExpression;
import io.intino.alexandria.sqlpredicate.expressions.LogicExpression;
import io.intino.alexandria.sqlpredicate.expressions.PropertyExpression;
import io.intino.alexandria.sqlpredicate.expressions.UnaryExpression;
import io.intino.alexandria.sqlpredicate.expressions.functions.FilterFunction;
import io.intino.alexandria.sqlpredicate.parser.InvalidExpressionException;
import io.intino.alexandria.sqlpredicate.parser.LRUCache;
import io.intino.alexandria.sqlpredicate.parser.ParseException;
import io.intino.alexandria.sqlpredicate.parser.PredicateParserConstants;
import io.intino.alexandria.sqlpredicate.parser.PredicateParserTokenManager;
import io.intino.alexandria.sqlpredicate.parser.SimpleCharStream;
import io.intino.alexandria.sqlpredicate.parser.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;

public class SqlPredicate {
    private static final Map<String, Object> cache = Collections.synchronizedMap(new LRUCache(100));
    private static final String CONVERT_STRING_EXPRESSIONS_PREFIX = "convert_string_expressions:";
    private String sql;
    private PredicateParserTokenManager toketSource;
    SimpleCharStream jjInputStream;
    private Token token;
    private int jjNtk;
    private Token jjScanPos;
    private Token jjLastPos;
    private int jjLa;
    private static final LookaheadSuccess jj_ls = new LookaheadSuccess();

    public static Predicate<EvaluationContext> parse(String sql) throws InvalidExpressionException {
        if (sql == null || sql.trim().isEmpty()) {
            return m -> true;
        }
        BooleanExpression expression = SqlPredicate.parseSQL(sql);
        return context -> {
            try {
                return expression.matches((EvaluationContext)context);
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
                return false;
            }
        };
    }

    public static void registerFunction(String name, FilterFunction function) {
        FunctionCallExpression.registerFunction(name, function);
    }

    static BooleanExpression parseSQL(String sql) throws InvalidExpressionException {
        Object result = cache.get(sql);
        if (result instanceof InvalidExpressionException) {
            throw (InvalidExpressionException)result;
        }
        if (result instanceof BooleanExpression) {
            return (BooleanExpression)result;
        }
        boolean convertStringExpressions = false;
        if (sql.startsWith(CONVERT_STRING_EXPRESSIONS_PREFIX)) {
            convertStringExpressions = true;
            sql = sql.substring(CONVERT_STRING_EXPRESSIONS_PREFIX.length());
        }
        if (convertStringExpressions) {
            ComparisonExpression.CONVERT_STRING_EXPRESSIONS.set(true);
        }
        try {
            BooleanExpression e = new SqlPredicate(sql).parse();
            cache.put(sql, e);
            BooleanExpression booleanExpression = e;
            return booleanExpression;
        }
        catch (InvalidExpressionException t) {
            cache.put(sql, t);
            throw t;
        }
        finally {
            if (convertStringExpressions) {
                ComparisonExpression.CONVERT_STRING_EXPRESSIONS.remove();
            }
        }
    }

    public static void clearCache() {
        cache.clear();
    }

    protected SqlPredicate(String sql) {
        this(new StringReader(sql));
        this.sql = sql;
    }

    protected BooleanExpression parse() throws InvalidExpressionException {
        try {
            return this.JmsSelector();
        }
        catch (Throwable e) {
            throw (InvalidExpressionException)new InvalidExpressionException(this.sql).initCause(e);
        }
    }

    private static BooleanExpression asBooleanExpression(Expression value) throws ParseException {
        if (value instanceof BooleanExpression) {
            return (BooleanExpression)value;
        }
        if (value instanceof PropertyExpression) {
            return UnaryExpression.createBooleanCast(value);
        }
        throw new ParseException("Expression will not result in a boolean value: " + value);
    }

    private BooleanExpression JmsSelector() throws ParseException {
        Expression left = this.orExpression();
        this.jj_consume_token(0);
        return SqlPredicate.asBooleanExpression(left);
    }

    private Expression orExpression() throws ParseException {
        Expression left = this.andExpression();
        while ((this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) == 10) {
            this.jj_consume_token(10);
            Expression right = this.andExpression();
            left = LogicExpression.createOR(SqlPredicate.asBooleanExpression(left), SqlPredicate.asBooleanExpression(right));
        }
        return left;
    }

    private Expression andExpression() throws ParseException {
        Expression left = this.equalityExpression();
        while ((this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) == 9) {
            this.jj_consume_token(9);
            Expression right = this.equalityExpression();
            left = LogicExpression.createAND(SqlPredicate.asBooleanExpression(left), SqlPredicate.asBooleanExpression(right));
        }
        return left;
    }

    private Expression equalityExpression() throws ParseException {
        Expression left;
        block9: {
            left = this.comparisonExpression();
            block7: while (true) {
                switch (this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) {
                    case 15: 
                    case 28: 
                    case 29: {
                        break;
                    }
                    default: {
                        break block9;
                    }
                }
                switch (this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) {
                    case 28: {
                        this.jj_consume_token(28);
                        Expression right = this.comparisonExpression();
                        left = ComparisonExpression.createEqual(left, right);
                        continue block7;
                    }
                    case 29: {
                        this.jj_consume_token(29);
                        Expression right = this.comparisonExpression();
                        left = ComparisonExpression.createNotEqual(left, right);
                        continue block7;
                    }
                }
                if (this.jj_2_1()) {
                    this.jj_consume_token(15);
                    this.jj_consume_token(18);
                    left = ComparisonExpression.createIsNull(left);
                    continue;
                }
                if ((this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) != 15) break;
                this.jj_consume_token(15);
                this.jj_consume_token(8);
                this.jj_consume_token(18);
                left = ComparisonExpression.createIsNotNull(left);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return left;
    }

    private Expression comparisonExpression() throws ParseException {
        Expression left;
        block19: {
            left = this.addExpression();
            block10: while (true) {
                ArrayList<String> list;
                Expression high;
                Expression low;
                String t;
                String u;
                switch (this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) {
                    case 8: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        break;
                    }
                    default: {
                        break block19;
                    }
                }
                switch (this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) {
                    case 30: {
                        this.jj_consume_token(30);
                        Expression right = this.addExpression();
                        left = ComparisonExpression.createGreaterThan(left, right);
                        continue block10;
                    }
                    case 31: {
                        this.jj_consume_token(31);
                        Expression right = this.addExpression();
                        left = ComparisonExpression.createGreaterThanEqual(left, right);
                        continue block10;
                    }
                    case 32: {
                        this.jj_consume_token(32);
                        Expression right = this.addExpression();
                        left = ComparisonExpression.createLessThan(left, right);
                        continue block10;
                    }
                    case 33: {
                        this.jj_consume_token(33);
                        Expression right = this.addExpression();
                        left = ComparisonExpression.createLessThanEqual(left, right);
                        continue block10;
                    }
                    case 12: {
                        u = null;
                        this.jj_consume_token(12);
                        t = this.stringLiteral();
                        if ((this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) == 13) {
                            this.jj_consume_token(13);
                            u = this.stringLiteral();
                        }
                        left = ComparisonExpression.createLike(left, t, u);
                        continue block10;
                    }
                }
                if (this.jj_2_2()) {
                    u = null;
                    this.jj_consume_token(8);
                    this.jj_consume_token(12);
                    t = this.stringLiteral();
                    if ((this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) == 13) {
                        this.jj_consume_token(13);
                        u = this.stringLiteral();
                    }
                    left = ComparisonExpression.createNotLike(left, t, u);
                    continue;
                }
                if ((this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) == 11) {
                    this.jj_consume_token(11);
                    low = this.addExpression();
                    this.jj_consume_token(9);
                    high = this.addExpression();
                    left = ComparisonExpression.createBetween(left, low, high);
                    continue;
                }
                if (this.jj_2_3()) {
                    this.jj_consume_token(8);
                    this.jj_consume_token(11);
                    low = this.addExpression();
                    this.jj_consume_token(9);
                    high = this.addExpression();
                    left = ComparisonExpression.createNotBetween(left, low, high);
                    continue;
                }
                if ((this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) == 14) {
                    this.jj_consume_token(14);
                    this.jj_consume_token(34);
                    t = this.stringLiteral();
                    list = new ArrayList<String>();
                    list.add(t);
                    while ((this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) == 35) {
                        this.jj_consume_token(35);
                        t = this.stringLiteral();
                        list.add(t);
                    }
                    this.jj_consume_token(36);
                    left = ComparisonExpression.createInFilter(left, list);
                    continue;
                }
                if (!this.jj_2_4()) break;
                this.jj_consume_token(8);
                this.jj_consume_token(14);
                this.jj_consume_token(34);
                t = this.stringLiteral();
                list = new ArrayList();
                list.add(t);
                while ((this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) == 35) {
                    this.jj_consume_token(35);
                    t = this.stringLiteral();
                    list.add(t);
                }
                this.jj_consume_token(36);
                left = ComparisonExpression.createNotInFilter(left, list);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return left;
    }

    private Expression addExpression() throws ParseException {
        Expression left = this.multExpr();
        block4: while (this.jj_2_5()) {
            switch (this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) {
                case 37: {
                    this.jj_consume_token(37);
                    Expression right = this.multExpr();
                    left = ArithmeticExpression.createPlus(left, right);
                    continue block4;
                }
                case 38: {
                    this.jj_consume_token(38);
                    Expression right = this.multExpr();
                    left = ArithmeticExpression.createMinus(left, right);
                    continue block4;
                }
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return left;
    }

    private Expression multExpr() throws ParseException {
        Expression left;
        block9: {
            left = this.unaryExpr();
            block8: while (true) {
                switch (this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) {
                    case 39: 
                    case 40: 
                    case 41: {
                        break;
                    }
                    default: {
                        break block9;
                    }
                }
                switch (this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) {
                    case 39: {
                        this.jj_consume_token(39);
                        Expression right = this.unaryExpr();
                        left = ArithmeticExpression.createMultiply(left, right);
                        continue block8;
                    }
                    case 40: {
                        this.jj_consume_token(40);
                        Expression right = this.unaryExpr();
                        left = ArithmeticExpression.createDivide(left, right);
                        continue block8;
                    }
                    case 41: {
                        this.jj_consume_token(41);
                        Expression right = this.unaryExpr();
                        left = ArithmeticExpression.createMod(left, right);
                        continue block8;
                    }
                }
                break;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return left;
    }

    private Expression unaryExpr() throws ParseException {
        Expression left;
        if (this.jj_2_6()) {
            this.jj_consume_token(37);
            left = this.unaryExpr();
        } else {
            block0 : switch (this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) {
                case 38: {
                    this.jj_consume_token(38);
                    left = this.unaryExpr();
                    left = UnaryExpression.createNegate(left);
                    break;
                }
                case 8: {
                    this.jj_consume_token(8);
                    left = this.unaryExpr();
                    left = UnaryExpression.createNOT(SqlPredicate.asBooleanExpression(left));
                    break;
                }
                default: {
                    if (this.jj_2_7()) {
                        left = this.functionCallExpr();
                        break;
                    }
                    switch (this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) {
                        case 16: 
                        case 17: 
                        case 18: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 26: 
                        case 27: 
                        case 34: {
                            left = this.primaryExpr();
                            break block0;
                        }
                    }
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return left;
    }

    private Expression functionCallExpr() throws ParseException {
        ArrayList<Expression> args = new ArrayList<Expression>();
        Token func_name = this.jj_consume_token(27);
        this.jj_consume_token(34);
        Expression arg = this.unaryExpr();
        args.add(arg);
        while ((this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) == 35) {
            this.jj_consume_token(35);
            arg = this.unaryExpr();
            args.add(arg);
        }
        this.jj_consume_token(36);
        try {
            return FunctionCallExpression.createFunctionCall(func_name.image, args);
        }
        catch (FunctionCallExpression.InvalidFunctionExpressionException inv_exc) {
            throw new Error("invalid function call expression", inv_exc);
        }
    }

    private Expression primaryExpr() throws ParseException {
        Expression left;
        switch (this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) {
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                left = this.literal();
                break;
            }
            case 27: {
                left = this.variable();
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                left = this.orExpression();
                this.jj_consume_token(36);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return left;
    }

    private ConstantExpression literal() throws ParseException {
        return switch (this.jjNtk == -1 ? this.jj_ntk_f() : this.jjNtk) {
            case 26 -> {
                String s = this.stringLiteral();
                yield new ConstantExpression(s);
            }
            case 21 -> {
                Token t = this.jj_consume_token(21);
                yield ConstantExpression.createFromDecimal(t.image);
            }
            case 22 -> {
                Token t = this.jj_consume_token(22);
                yield ConstantExpression.createFromHex(t.image);
            }
            case 23 -> {
                Token t = this.jj_consume_token(23);
                yield ConstantExpression.createFromOctal(t.image);
            }
            case 24 -> {
                Token t = this.jj_consume_token(24);
                yield ConstantExpression.createFloat(t.image);
            }
            case 16 -> {
                this.jj_consume_token(16);
                yield ConstantExpression.TRUE;
            }
            case 17 -> {
                this.jj_consume_token(17);
                yield ConstantExpression.FALSE;
            }
            case 18 -> {
                this.jj_consume_token(18);
                yield ConstantExpression.NULL;
            }
            default -> {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    private String stringLiteral() throws ParseException {
        StringBuilder rc = new StringBuilder();
        Token t = this.jj_consume_token(26);
        String image = t.image;
        for (int i = 1; i < image.length() - 1; ++i) {
            char c = image.charAt(i);
            if (c == '\'') {
                ++i;
            }
            rc.append(c);
        }
        return rc.toString();
    }

    private PropertyExpression variable() throws ParseException {
        Token t = this.jj_consume_token(27);
        PropertyExpression left = new PropertyExpression(t.image);
        return left;
    }

    private boolean jj_2_1() {
        this.jjLa = 2;
        this.jjLastPos = this.jjScanPos = this.token;
        try {
            return !this.jj_3_1();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_2() {
        this.jjLa = 2;
        this.jjLastPos = this.jjScanPos = this.token;
        try {
            return !this.jj_3_2();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_3() {
        this.jjLa = 2;
        this.jjLastPos = this.jjScanPos = this.token;
        try {
            return !this.jj_3_3();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_4() {
        this.jjLa = 2;
        this.jjLastPos = this.jjScanPos = this.token;
        try {
            return !this.jj_3_4();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_5() {
        this.jjLa = Integer.MAX_VALUE;
        this.jjLastPos = this.jjScanPos = this.token;
        try {
            return !this.jj_3_5();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_6() {
        this.jjLa = Integer.MAX_VALUE;
        this.jjLastPos = this.jjScanPos = this.token;
        try {
            return !this.jj_3_6();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_7() {
        this.jjLa = Integer.MAX_VALUE;
        this.jjLastPos = this.jjScanPos = this.token;
        try {
            return !this.jj_3_7();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_3R_unaryExpr_469_5_11() {
        Token xsp = this.jjScanPos;
        if (this.jj_3R_unaryExpr_470_9_13()) {
            this.jjScanPos = xsp;
            if (this.jj_3R_unaryExpr_473_9_14()) {
                this.jjScanPos = xsp;
                if (this.jj_3R_unaryExpr_478_9_15()) {
                    this.jjScanPos = xsp;
                    if (this.jj_3R_unaryExpr_483_9_16()) {
                        this.jjScanPos = xsp;
                        if (this.jj_3R_unaryExpr_488_9_17()) {
                            this.jjScanPos = xsp;
                            if (this.jj_3R_unaryExpr_493_13_18()) {
                                this.jjScanPos = xsp;
                                return this.jj_3R_unaryExpr_496_9_19();
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_comparisonExpression_358_17_59() {
        Token xsp;
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_scan_token(34)) {
            return true;
        }
        if (this.jj_3R_stringLitteral_635_5_23()) {
            return true;
        }
        do {
            xsp = this.jjScanPos;
        } while (!this.jj_3R_comparisonExpression_366_25_64());
        this.jjScanPos = xsp;
        return this.jj_scan_token(36);
    }

    private boolean jj_3R_equalityExpression_267_13_49() {
        return this.jj_scan_token(28) || this.jj_3R_comparisonExpression_305_5_45();
    }

    private boolean jj_3R_equalityExpression_267_13_46() {
        Token xsp = this.jjScanPos;
        if (this.jj_3R_equalityExpression_267_13_49()) {
            this.jjScanPos = xsp;
            if (this.jj_3R_equalityExpression_272_13_50()) {
                this.jjScanPos = xsp;
                if (this.jj_3_1()) {
                    this.jjScanPos = xsp;
                    return this.jj_3R_equalityExpression_283_13_51();
                }
            }
        }
        return false;
    }

    private boolean jj_3R_variable_655_5_31() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3_3() {
        return this.jj_scan_token(8) || this.jj_scan_token(11) || this.jj_3R_addExpression_412_5_47() || this.jj_scan_token(9) || this.jj_3R_addExpression_412_5_47();
    }

    private boolean jj_3R_primaryExpr_550_9_29() {
        return this.jj_scan_token(34) || this.jj_3R_orExpression_221_5_32() || this.jj_scan_token(36);
    }

    private boolean jj_3R_primaryExpr_548_9_28() {
        return this.jj_3R_variable_655_5_31();
    }

    private boolean jj_3R_multExpr_451_9_22() {
        return this.jj_scan_token(41) || this.jj_3R_unaryExpr_469_5_11();
    }

    private boolean jj_3R_primaryExpr_546_9_27() {
        return this.jj_3R_literal_566_5_30();
    }

    private boolean jj_3R_comparisonExpression_347_17_58() {
        return this.jj_scan_token(11) || this.jj_3R_addExpression_412_5_47() || this.jj_scan_token(9) || this.jj_3R_addExpression_412_5_47();
    }

    private boolean jj_3R_equalityExpression_263_5_43() {
        Token xsp;
        if (this.jj_3R_comparisonExpression_305_5_45()) {
            return true;
        }
        do {
            xsp = this.jjScanPos;
        } while (!this.jj_3R_equalityExpression_267_13_46());
        this.jjScanPos = xsp;
        return false;
    }

    private boolean jj_3R_multExpr_446_9_21() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        return this.jj_3R_unaryExpr_469_5_11();
    }

    private boolean jj_3R_primaryExpr_545_5_25() {
        Token xsp = this.jjScanPos;
        if (this.jj_3R_primaryExpr_546_9_27()) {
            this.jjScanPos = xsp;
            if (this.jj_3R_primaryExpr_548_9_28()) {
                this.jjScanPos = xsp;
                return this.jj_3R_primaryExpr_550_9_29();
            }
        }
        return false;
    }

    private boolean jj_3R_comparisonExpression_333_23_62() {
        return this.jj_scan_token(13) || this.jj_3R_stringLitteral_635_5_23();
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_3R_stringLitteral_635_5_23()) {
            return true;
        }
        Token xsp = this.jjScanPos;
        if (this.jj_3R_comparisonExpression_342_53_63()) {
            this.jjScanPos = xsp;
        }
        return false;
    }

    private boolean jj_3R_multExpr_441_9_12() {
        Token xsp = this.jjScanPos;
        if (this.jj_3R_multExpr_441_9_20()) {
            this.jjScanPos = xsp;
            if (this.jj_3R_multExpr_446_9_21()) {
                this.jjScanPos = xsp;
                return this.jj_3R_multExpr_451_9_22();
            }
        }
        return false;
    }

    private boolean jj_3R_multExpr_441_9_20() {
        return this.jj_scan_token(39) || this.jj_3R_unaryExpr_469_5_11();
    }

    private boolean jj_3R_stringLitteral_635_5_23() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_andExpression_246_13_44() {
        return this.jj_scan_token(9) || this.jj_3R_equalityExpression_263_5_43();
    }

    private boolean jj_3R_multExpr_439_5_10() {
        Token xsp;
        if (this.jj_3R_unaryExpr_469_5_11()) {
            return true;
        }
        do {
            xsp = this.jjScanPos;
        } while (!this.jj_3R_multExpr_441_9_12());
        this.jjScanPos = xsp;
        return false;
    }

    private boolean jj_3R_comparisonExpression_329_17_57() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_3R_stringLitteral_635_5_23()) {
            return true;
        }
        Token xsp = this.jjScanPos;
        if (this.jj_3R_comparisonExpression_333_23_62()) {
            this.jjScanPos = xsp;
        }
        return false;
    }

    private boolean jj_3R_andExpression_243_5_41() {
        Token xsp;
        if (this.jj_3R_equalityExpression_263_5_43()) {
            return true;
        }
        do {
            xsp = this.jjScanPos;
        } while (!this.jj_3R_andExpression_246_13_44());
        this.jjScanPos = xsp;
        return false;
    }

    private boolean jj_3R_functionCallExpr_519_13_26() {
        return this.jj_scan_token(35) || this.jj_3R_unaryExpr_469_5_11();
    }

    private boolean jj_3R_comparisonExpression_324_17_56() {
        return this.jj_scan_token(33) || this.jj_3R_addExpression_412_5_47();
    }

    private boolean jj_3R_literal_616_9_40() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_addExpression_421_13_61() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        return this.jj_3R_multExpr_439_5_10();
    }

    private boolean jj_3_5() {
        Token xsp = this.jjScanPos;
        if (this.jj_scan_token(37)) {
            this.jjScanPos = xsp;
            if (this.jj_scan_token(38)) {
                return true;
            }
        }
        return this.jj_3R_multExpr_439_5_10();
    }

    private boolean jj_3R_comparisonExpression_319_17_55() {
        return this.jj_scan_token(32) || this.jj_3R_addExpression_412_5_47();
    }

    private boolean jj_3R_addExpression_416_13_60() {
        return this.jj_scan_token(37) || this.jj_3R_multExpr_439_5_10();
    }

    private boolean jj_3R_literal_609_9_39() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_orExpression_224_13_42() {
        return this.jj_scan_token(10) || this.jj_3R_andExpression_243_5_41();
    }

    private boolean jj_3R_comparisonExpression_314_17_54() {
        return this.jj_scan_token(31) || this.jj_3R_addExpression_412_5_47();
    }

    private boolean jj_3R_addExpression_414_9_52() {
        Token xsp = this.jjScanPos;
        if (this.jj_3R_addExpression_416_13_60()) {
            this.jjScanPos = xsp;
            return this.jj_3R_addExpression_421_13_61();
        }
        return false;
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_functionCallExpr_512_5_24() {
        Token xsp;
        if (this.jj_scan_token(27) || this.jj_scan_token(34) || this.jj_3R_unaryExpr_469_5_11()) {
            return true;
        }
        do {
            xsp = this.jjScanPos;
        } while (!this.jj_3R_functionCallExpr_519_13_26());
        this.jjScanPos = xsp;
        return this.jj_scan_token(36);
    }

    private boolean jj_3R_comparisonExpression_309_17_53() {
        return this.jj_scan_token(30) || this.jj_3R_addExpression_412_5_47();
    }

    private boolean jj_3R_comparisonExpression_309_17_48() {
        Token xsp = this.jjScanPos;
        if (this.jj_3R_comparisonExpression_309_17_53()) {
            this.jjScanPos = xsp;
            if (this.jj_3R_comparisonExpression_314_17_54()) {
                this.jjScanPos = xsp;
                if (this.jj_3R_comparisonExpression_319_17_55()) {
                    this.jjScanPos = xsp;
                    if (this.jj_3R_comparisonExpression_324_17_56()) {
                        this.jjScanPos = xsp;
                        if (this.jj_3R_comparisonExpression_329_17_57()) {
                            this.jjScanPos = xsp;
                            if (this.jj_3_2()) {
                                this.jjScanPos = xsp;
                                if (this.jj_3R_comparisonExpression_347_17_58()) {
                                    this.jjScanPos = xsp;
                                    if (this.jj_3_3()) {
                                        this.jjScanPos = xsp;
                                        if (this.jj_3R_comparisonExpression_358_17_59()) {
                                            this.jjScanPos = xsp;
                                            return this.jj_3_4();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_literal_602_9_38() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3R_addExpression_412_5_47() {
        Token xsp;
        if (this.jj_3R_multExpr_439_5_10()) {
            return true;
        }
        do {
            xsp = this.jjScanPos;
        } while (!this.jj_3R_addExpression_414_9_52());
        this.jjScanPos = xsp;
        return false;
    }

    private boolean jj_3R_orExpression_221_5_32() {
        Token xsp;
        if (this.jj_3R_andExpression_243_5_41()) {
            return true;
        }
        do {
            xsp = this.jjScanPos;
        } while (!this.jj_3R_orExpression_224_13_42());
        this.jjScanPos = xsp;
        return false;
    }

    private boolean jj_3R_literal_595_9_37() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_comparisonExpression_387_25_65() {
        return this.jj_scan_token(35) || this.jj_3R_stringLitteral_635_5_23();
    }

    private boolean jj_3R_unaryExpr_493_13_18() {
        return this.jj_3R_functionCallExpr_512_5_24();
    }

    private boolean jj_3R_unaryExpr_496_9_19() {
        return this.jj_3R_primaryExpr_545_5_25();
    }

    private boolean jj_3R_literal_588_9_36() {
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_comparisonExpression_305_5_45() {
        Token xsp;
        if (this.jj_3R_addExpression_412_5_47()) {
            return true;
        }
        do {
            xsp = this.jjScanPos;
        } while (!this.jj_3R_comparisonExpression_309_17_48());
        this.jjScanPos = xsp;
        return false;
    }

    private boolean jj_3R_unaryExpr_488_9_17() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_3R_stringLitteral_635_5_23();
    }

    private boolean jj_3R_literal_581_9_35() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_unaryExpr_483_9_16() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_3R_stringLitteral_635_5_23();
    }

    private boolean jj_3R_comparisonExpression_342_53_63() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_stringLitteral_635_5_23();
    }

    private boolean jj_3_4() {
        Token xsp;
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_scan_token(34)) {
            return true;
        }
        if (this.jj_3R_stringLitteral_635_5_23()) {
            return true;
        }
        do {
            xsp = this.jjScanPos;
        } while (!this.jj_3R_comparisonExpression_387_25_65());
        this.jjScanPos = xsp;
        return this.jj_scan_token(36);
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(37)) {
            return true;
        }
        return this.jj_3R_unaryExpr_469_5_11();
    }

    private boolean jj_3R_literal_574_9_34() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3R_unaryExpr_478_9_15() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_unaryExpr_469_5_11();
    }

    private boolean jj_3R_comparisonExpression_366_25_64() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        return this.jj_3R_stringLitteral_635_5_23();
    }

    private boolean jj_3R_equalityExpression_283_13_51() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_unaryExpr_473_9_14() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        return this.jj_3R_unaryExpr_469_5_11();
    }

    private boolean jj_3R_literal_567_9_33() {
        return this.jj_3R_stringLitteral_635_5_23();
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_unaryExpr_470_9_13() {
        if (this.jj_scan_token(37)) {
            return true;
        }
        return this.jj_3R_unaryExpr_469_5_11();
    }

    private boolean jj_3R_literal_566_5_30() {
        Token xsp = this.jjScanPos;
        if (this.jj_3R_literal_567_9_33()) {
            this.jjScanPos = xsp;
            if (this.jj_3R_literal_574_9_34()) {
                this.jjScanPos = xsp;
                if (this.jj_3R_literal_581_9_35()) {
                    this.jjScanPos = xsp;
                    if (this.jj_3R_literal_588_9_36()) {
                        this.jjScanPos = xsp;
                        if (this.jj_3R_literal_595_9_37()) {
                            this.jjScanPos = xsp;
                            if (this.jj_3R_literal_602_9_38()) {
                                this.jjScanPos = xsp;
                                if (this.jj_3R_literal_609_9_39()) {
                                    this.jjScanPos = xsp;
                                    return this.jj_3R_literal_616_9_40();
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_equalityExpression_272_13_50() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        return this.jj_3R_comparisonExpression_305_5_45();
    }

    SqlPredicate(Reader stream) {
        this.jjInputStream = new SimpleCharStream(stream, 1, 1);
        this.toketSource = new PredicateParserTokenManager(this.jjInputStream);
        this.token = new Token();
        this.jjNtk = -1;
    }

    SqlPredicate(InputStream stream, String encoding) {
        try {
            this.jjInputStream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.toketSource = new PredicateParserTokenManager(this.jjInputStream);
        this.token = new Token();
        this.jjNtk = -1;
    }

    private void reInit(InputStream stream) {
        this.reInit(stream, null);
    }

    private void reInit(InputStream stream, String encoding) {
        try {
            this.jjInputStream.reInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.toketSource.ReInit(this.jjInputStream);
        this.token = new Token();
        this.jjNtk = -1;
    }

    private void reInit(Reader stream) {
        if (this.jjInputStream == null) {
            this.jjInputStream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jjInputStream.reInit(stream, 1, 1);
        }
        if (this.toketSource == null) {
            this.toketSource = new PredicateParserTokenManager(this.jjInputStream);
        }
        this.toketSource.ReInit(this.jjInputStream);
        this.token = new Token();
        this.jjNtk = -1;
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.toketSource.getNextToken());
        this.jjNtk = -1;
        if (this.token.kind == kind) {
            return this.token;
        }
        this.token = oldToken;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jjScanPos == this.jjLastPos) {
            --this.jjLa;
            if (this.jjScanPos.next == null) {
                this.jjScanPos = this.jjScanPos.next = this.toketSource.getNextToken();
                this.jjLastPos = this.jjScanPos.next;
            } else {
                this.jjLastPos = this.jjScanPos = this.jjScanPos.next;
            }
        } else {
            this.jjScanPos = this.jjScanPos.next;
        }
        if (this.jjScanPos.kind != kind) {
            return true;
        }
        if (this.jjLa == 0 && this.jjScanPos == this.jjLastPos) {
            throw jj_ls;
        }
        return false;
    }

    private int jj_ntk_f() {
        Token jj_nt = this.token.next;
        if (jj_nt == null) {
            this.token.next = this.toketSource.getNextToken();
            this.jjNtk = this.token.next.kind;
            return this.jjNtk;
        }
        this.jjNtk = jj_nt.kind;
        return this.jjNtk;
    }

    private ParseException generateParseException() {
        Token errortok = this.token.next;
        int line = errortok.beginLine;
        int column = errortok.beginColumn;
        String mess = errortok.kind == 0 ? PredicateParserConstants.tokenImage[0] : errortok.image;
        return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

