/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.intino.alexandria.Envelope;
import io.intino.alexandria.xml.Xml;
import java.util.Map;

public class Soap {
    private static final String envelopTemplate = "<?xml version='1.0' encoding='UTF-8'?>\n<S:Envelope xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\">\n\t<S:Body>\n\t\t$schema\n\t</S:Body>\n</S:Envelope>";
    private static final String schemaTemplate = "<R:$name xmlns:R=\"$xmlns\">\n$parameter\t\t</R:$name>";
    private static final String parameterTemplate = "\t\t\t<R:$name>$value</R:$name>\n";

    public Envelope readEnvelope(String value) {
        return new Envelope(new Xml(value).document().getFirstChild());
    }

    public String writeEnvelope(Object schema, String xmlns) {
        if (schema == null) {
            return this.render(schema, "", xmlns);
        }
        JsonElement jsonElement = new GsonBuilder().create().toJsonTree(schema);
        return this.render(schema, this.parameters(jsonElement), xmlns);
    }

    private String parameters(JsonElement jsonElement) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry child : jsonElement.getAsJsonObject().entrySet()) {
            result.append(parameterTemplate.replace("$name", (CharSequence)child.getKey()).replace("$value", ((JsonElement)child.getValue()).getAsString()));
        }
        return result.toString();
    }

    private String render(Object schema, String parameters, String xmlns) {
        String template = schemaTemplate.replace("$name", Soap.firstLowerCase(schema.getClass().getSimpleName())).replace("$xmlns", xmlns);
        return envelopTemplate.replace("$schema", template.replace("$parameter", parameters));
    }

    public static String firstLowerCase(String value) {
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }
}

