/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.sealing;

import io.intino.alexandria.FS;
import io.intino.alexandria.Fingerprint;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.sealing.EventSealer;
import io.intino.alexandria.sealing.SessionSealer;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EventSessionSealer {
    private final Datalake datalake;
    private final File stageDir;
    private final File tmpDir;
    private final File treatedDir;

    public EventSessionSealer(Datalake datalake, File stageDir, File tmpDir, File treatedDir) {
        this.datalake = datalake;
        this.stageDir = stageDir;
        this.tmpDir = tmpDir;
        this.treatedDir = treatedDir;
    }

    public void seal() {
        this.seal(SessionSealer.TankNameFilter.acceptAll());
    }

    public void seal(SessionSealer.TankNameFilter tankNameFilter) {
        EventSessionSealer.sessions(this.stageDir).collect(Collectors.groupingBy(EventSessionSealer::fingerprintOf)).entrySet().stream().sorted(Comparator.comparing(t -> ((Fingerprint)t.getKey()).toString())).forEach(e -> this.seal(tankNameFilter, (Map.Entry<Fingerprint, List<File>>)e));
    }

    private void seal(SessionSealer.TankNameFilter tankNameFilter, Map.Entry<Fingerprint, List<File>> e) {
        try {
            new EventSealer(this.datalake, tankNameFilter, this.tmpDir).seal(e.getKey(), e.getValue());
            this.moveTreated(e);
        }
        catch (IOException ex) {
            Logger.error((Throwable)ex);
        }
    }

    private void moveTreated(Map.Entry<Fingerprint, List<File>> e) {
        e.getValue().forEach(f -> f.renameTo(new File(this.treatedDir, f.getName() + ".treated")));
    }

    private static Stream<File> sessions(File stage) {
        if (!stage.exists()) {
            return Stream.empty();
        }
        try {
            return FS.allFilesIn((File)stage, f -> f.getName().endsWith(".session") && (float)f.length() > 0.0f);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return Stream.empty();
        }
    }

    private static Fingerprint fingerprintOf(File file) {
        return Fingerprint.of((File)file);
    }
}

