/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.restaccessor.core;

import io.intino.alexandria.restaccessor.core.ExternalSignatureCMSSignedDataGenerator;
import io.intino.alexandria.restaccessor.core.ExternalSignatureSignerInfoGenerator;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

class Signer {
    private static final String ParameterMask = "%s=%s";

    Signer() {
    }

    String hash(Map<String, String> parameters, long timestamp) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            result.append(String.format(ParameterMask, param.getKey(), param.getValue()));
            result.append("&");
        }
        result.append(String.format(ParameterMask, "timestamp", String.valueOf(timestamp)));
        return result.toString();
    }

    String sign(String text, URL certificate, String password) throws Exception {
        byte[] data = this.signText(text.getBytes(), certificate, password);
        return new String(Base64.encode((byte[])data));
    }

    private byte[] signText(byte[] text, URL certificate, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        X509Certificate[] chain = new X509Certificate[1];
        keyStore.load(certificate.openStream(), password.toCharArray());
        String certificateAlias = keyStore.aliases().nextElement();
        chain[0] = (X509Certificate)keyStore.getCertificate(certificateAlias);
        return this.createSignature(text, certificateAlias, keyStore, chain, password.toCharArray());
    }

    private byte[] createSignature(byte[] hash, String privateKeyAlias, KeyStore keyStore, X509Certificate[] chain, char[] password) throws Exception {
        ExternalSignatureCMSSignedDataGenerator generator = new ExternalSignatureCMSSignedDataGenerator();
        ExternalSignatureSignerInfoGenerator si = new ExternalSignatureSignerInfoGenerator(CMSSignedDataGenerator.DIGEST_SHA1, CMSSignedDataGenerator.ENCRYPTION_RSA);
        byte[] signedBytes = this.signMessage(hash, keyStore, privateKeyAlias, password);
        si.setCertificate(chain[0]);
        si.setSignedBytes(signedBytes);
        generator.addSignerInf(si);
        generator.addCertificatesAndCRLs(this.getCertStore(chain));
        CMSSignedData signedData = generator.generate((CMSProcessable)new CMSProcessableByteArray(hash), true);
        return signedData.getEncoded();
    }

    private CertStore getCertStore(Certificate[] certs) throws GeneralSecurityException {
        int length;
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        int n = length = certs == null ? 0 : certs.length;
        for (int i = 0; i < length; ++i) {
            list.add(certs[i]);
        }
        return CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(list), "BC");
    }

    private byte[] signMessage(byte[] textBytes, KeyStore keyStore, String certificateAlias, char[] password) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        PrivateKey privatekey = (PrivateKey)keyStore.getKey(certificateAlias, password);
        if (privatekey == null) {
            return null;
        }
        Signature signature = Signature.getInstance("SHA1withRSA", keyStore.getProvider());
        signature.initSign(privatekey);
        signature.update(textBytes);
        byte[] abyte1 = signature.sign();
        return abyte1;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

