/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.restaccessor.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataGenerator;

public class ExternalSignatureSignerInfoGenerator {
    X509Certificate cert = null;
    byte[] signedBytes;
    String digestOID;
    String encOID;
    AttributeTable sAttr = null;
    AttributeTable unsAttr = null;
    ASN1Set signedAttr = null;
    ASN1Set unsignedAttr = null;

    public ExternalSignatureSignerInfoGenerator(String digestOID, String encOID) {
        this.digestOID = digestOID;
        this.encOID = encOID;
    }

    X509Certificate getCertificate() {
        return this.cert;
    }

    public void setCertificate(X509Certificate c) {
        this.cert = c;
    }

    String getDigestAlgOID() {
        return this.digestOID;
    }

    byte[] getDigestAlgParams() {
        return null;
    }

    String getEncryptionAlgOID() {
        return this.encOID;
    }

    AttributeTable getSignedAttributes() {
        return this.sAttr;
    }

    AttributeTable getUnsignedAttributes() {
        return this.unsAttr;
    }

    String getDigestAlgName() {
        String digestAlgOID = this.getDigestAlgOID();
        if (CMSSignedDataGenerator.DIGEST_MD5.equals(digestAlgOID)) {
            return "MD5";
        }
        if (CMSSignedDataGenerator.DIGEST_SHA1.equals(digestAlgOID)) {
            return "SHA1";
        }
        if (CMSSignedDataGenerator.DIGEST_SHA224.equals(digestAlgOID)) {
            return "SHA224";
        }
        return digestAlgOID;
    }

    String getEncryptionAlgName() {
        String encryptionAlgOID = this.getEncryptionAlgOID();
        if (CMSSignedDataGenerator.ENCRYPTION_DSA.equals(encryptionAlgOID)) {
            return "DSA";
        }
        if (CMSSignedDataGenerator.ENCRYPTION_RSA.equals(encryptionAlgOID)) {
            return "RSA";
        }
        return encryptionAlgOID;
    }

    SignerInfo generate() throws CertificateEncodingException, IOException {
        AlgorithmIdentifier digAlgId = null;
        AlgorithmIdentifier encAlgId = null;
        digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(this.getDigestAlgOID()), (DEREncodable)new DERNull());
        encAlgId = this.getEncryptionAlgOID().equals(CMSSignedDataGenerator.ENCRYPTION_DSA) ? new AlgorithmIdentifier(new DERObjectIdentifier(this.getEncryptionAlgOID())) : new AlgorithmIdentifier(new DERObjectIdentifier(this.getEncryptionAlgOID()), (DEREncodable)new DERNull());
        DEROctetString encDigest = new DEROctetString(this.signedBytes);
        X509Certificate cert = this.getCertificate();
        ByteArrayInputStream bIn = new ByteArrayInputStream(cert.getTBSCertificate());
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        DERObject derObject = aIn.readObject();
        aIn.close();
        TBSCertificateStructure tbs = TBSCertificateStructure.getInstance((Object)derObject);
        IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), cert.getSerialNumber());
        return new SignerInfo(new SignerIdentifier(encSid), digAlgId, this.signedAttr, encAlgId, (ASN1OctetString)encDigest, this.unsignedAttr);
    }

    public byte[] getBytesToSign(DERObjectIdentifier contentType, byte[] hash, String sigProvider) throws IOException, SignatureException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, CertificateEncodingException, CMSException {
        DEREncodableVector v;
        AttributeTable attr = this.getSignedAttributes();
        if (attr != null) {
            v = new DEREncodableVector();
            if (attr.get(CMSAttributes.contentType) == null) {
                v.add((DEREncodable)new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((DEREncodable)contentType)));
            } else {
                v.add((DEREncodable)attr.get(CMSAttributes.contentType));
            }
            if (attr.get(CMSAttributes.signingTime) == null) {
                v.add((DEREncodable)new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((DEREncodable)new Time(new Date()))));
            } else {
                v.add((DEREncodable)attr.get(CMSAttributes.signingTime));
            }
            v.add((DEREncodable)new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((DEREncodable)new DEROctetString(hash))));
            Hashtable ats = attr.toHashtable();
            ats.remove(CMSAttributes.contentType);
            ats.remove(CMSAttributes.signingTime);
            ats.remove(CMSAttributes.messageDigest);
            Iterator it = ats.values().iterator();
            while (it.hasNext()) {
                v.add((DEREncodable)Attribute.getInstance(it.next()));
            }
            this.signedAttr = new DERSet(v);
        } else {
            v = new DEREncodableVector();
            v.add((DEREncodable)new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((DEREncodable)contentType)));
            v.add((DEREncodable)new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((DEREncodable)new DERUTCTime(new Date()))));
            v.add((DEREncodable)new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((DEREncodable)new DEROctetString(hash))));
            this.signedAttr = new DERSet(v);
        }
        attr = this.getUnsignedAttributes();
        if (attr != null) {
            Hashtable ats = attr.toHashtable();
            Iterator it = ats.values().iterator();
            DEREncodableVector v2 = new DEREncodableVector();
            while (it.hasNext()) {
                v2.add((DEREncodable)Attribute.getInstance(it.next()));
            }
            this.unsignedAttr = new DERSet(v2);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
        dOut.writeObject((Object)this.signedAttr);
        byte[] result = bOut.toByteArray();
        dOut.close();
        return result;
    }

    public void setSignedBytes(byte[] signedBytes) {
        this.signedBytes = signedBytes;
    }

    static class DigOutputStream
    extends OutputStream {
        MessageDigest dig;

        public DigOutputStream(MessageDigest dig) {
            this.dig = dig;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.dig.update(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.dig.update((byte)b);
        }
    }
}

