/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.restaccessor.adapters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.intino.alexandria.Json;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class ResponseAdapter {
    private static Gson gsonReader = Json.gsonReader();
    private static Gson gsonWriter = Json.gsonWriter();

    public static <T> T adapt(String object, Class<T> type) {
        T result = ResponseAdapter.adaptPrimitive(object, type);
        return result != null ? result : ResponseAdapter.adaptFromJSON(object, type);
    }

    public static <T> T adaptFromJSON(String object, Class<T> type) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Instant.class, (json, type1, jsonDeserializationContext) -> Instant.ofEpochMilli(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter(Date.class, (json, type1, jsonDeserializationContext) -> new Date(json.getAsJsonPrimitive().getAsLong()));
        return (T)(object == null || object.isEmpty() ? null : builder.create().fromJson(ResponseAdapter.decode(object), type));
    }

    public static <T> T adapt(String object, Type type) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Instant.class, (json, type1, jsonDeserializationContext) -> Instant.ofEpochMilli(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter(Date.class, (json, type1, jsonDeserializationContext) -> new Date(json.getAsJsonPrimitive().getAsLong()));
        return (T)(object == null || object.isEmpty() ? null : builder.create().fromJson(ResponseAdapter.decode(object), type));
    }

    private static String decode(String object) {
        try {
            return URLDecoder.decode(object, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException ex) {
            return object;
        }
    }

    private static <T> T adaptPrimitive(String object, Class<T> type) {
        if (type == String.class) {
            return (T)object;
        }
        if (type == Double.class) {
            return (T)Double.valueOf(object);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(object);
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(object);
        }
        if (type == Instant.class) {
            return (T)Instant.ofEpochMilli(Long.parseLong(object));
        }
        if (type == LocalDate.class) {
            return (T)LocalDate.ofEpochDay(Long.parseLong(object));
        }
        if (type == LocalDateTime.class) {
            return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(object)), ZoneId.of("UTC"));
        }
        return null;
    }
}

