/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.restaccessor;

import io.intino.alexandria.Base64;
import io.intino.alexandria.Json;
import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.ExceptionFactory;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.restaccessor.Response;
import io.intino.alexandria.restaccessor.adapters.RequestAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;

public class RequestBuilder {
    private final URL url;
    private final List<NameValuePair> queryParameters;
    private final HttpClient client;
    private final Map<String, String> headerParameters;
    private final Map<String, String> entityParts;
    private final List<Resource> resources;
    private int timeOutMillis;
    private Auth auth;
    private Method method;
    private String path;

    public RequestBuilder(URL url) {
        this.url = url;
        this.timeOutMillis = 120000;
        this.queryParameters = new ArrayList<NameValuePair>();
        this.headerParameters = new LinkedHashMap<String, String>();
        this.entityParts = new LinkedHashMap<String, String>();
        this.resources = new ArrayList<Resource>();
        this.client = this.client();
    }

    public RequestBuilder timeOut(int timeOutMillis) {
        this.timeOutMillis = timeOutMillis;
        return this;
    }

    public RequestBuilder basicAuth(String user, String password) {
        this.auth = Auth.Basic.with(Base64.encode((byte[])(user + ":" + password).getBytes()));
        return this;
    }

    public RequestBuilder bearerAuth(String token) {
        this.auth = Auth.Bearer.with(token);
        return this;
    }

    public RequestBuilder queryParameter(String name, Object value) {
        if (value != null) {
            this.queryParameters.add((NameValuePair)new BasicNameValuePair(name, RequestAdapter.adapt(value)));
        }
        return this;
    }

    public RequestBuilder headerParameter(String name, Object value) {
        if (value != null) {
            this.headerParameters.put(name, RequestAdapter.adapt(value));
        }
        return this;
    }

    public RequestBuilder entityPart(String name, Object content) {
        if (content != null) {
            this.entityParts.put(name, RequestAdapter.adapt(content));
        }
        return this;
    }

    public RequestBuilder entityPart(Resource resource) {
        this.resources.add(resource);
        return this;
    }

    public Request build(Method method, String path) {
        this.method = method;
        this.path = path;
        return this.build();
    }

    Request build() {
        return new Request(){

            @Override
            public Response execute() throws AlexandriaException {
                try {
                    HttpRequestBase request = RequestBuilder.this.method(RequestBuilder.this.method.name());
                    if (RequestBuilder.this.auth != null) {
                        request.setHeader("Authorization", RequestBuilder.this.auth.name() + " " + RequestBuilder.this.auth.token);
                    }
                    RequestBuilder.this.headerParameters.forEach((arg_0, arg_1) -> ((HttpRequestBase)request).setHeader(arg_0, arg_1));
                    if (!RequestBuilder.this.entityParts.isEmpty() && request instanceof HttpEntityEnclosingRequestBase) {
                        ((HttpEntityEnclosingRequestBase)request).setEntity(RequestBuilder.this.buildEntity());
                    }
                    request.setURI(RequestBuilder.this.buildUrl());
                    return RequestBuilder.this.responseFrom(RequestBuilder.this.client.execute((HttpUriRequest)request));
                }
                catch (IOException | URISyntaxException e) {
                    throw new InternalServerError(e.getMessage());
                }
            }

            public String toString() {
                return Json.toString((Object)RequestBuilder.this);
            }
        };
    }

    private URI buildUrl() throws URISyntaxException {
        return new URIBuilder(this.pathUrl(this.url, this.path)).setParameters(this.queryParameters).build();
    }

    private HttpEntity buildEntity() {
        if (this.entityParts.size() == 1) {
            return this.stringEntity(String.valueOf(this.entityParts.values().iterator().next()));
        }
        return this.multipartEntity();
    }

    private HttpEntity multipartEntity() {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setContentType(ContentType.MULTIPART_FORM_DATA).setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(StandardCharsets.UTF_8);
        this.resources.forEach(r -> builder.addPart(r.name(), (ContentBody)new InputStreamBody(r.stream(), r.type() != null ? ContentType.create((String)r.type()) : ContentType.APPLICATION_OCTET_STREAM, r.name())));
        this.entityParts.forEach((key, value) -> builder.addPart(key, (ContentBody)new StringBody(value, ContentType.APPLICATION_JSON)));
        return builder.build();
    }

    private HttpEntity stringEntity(String body) {
        StringEntity entity = new StringEntity(body, ContentType.APPLICATION_JSON);
        entity.setContentEncoding(StandardCharsets.UTF_8.displayName());
        return entity;
    }

    private HttpClient client() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.timeOutMillis).build();
        return HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setDefaultRequestConfig(requestConfig).build();
    }

    private HttpRequestBase method(String methodName) {
        if ("GET".equals(methodName)) {
            return new HttpGet();
        }
        if ("POST".equals(methodName)) {
            return new HttpPost();
        }
        if ("PATCH".equals(methodName)) {
            return new HttpPatch();
        }
        if ("PUT".equals(methodName)) {
            return new HttpPut();
        }
        return new HttpDelete();
    }

    private String pathUrl(URL url, String path) {
        String baseUrl = url.toString();
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return path.isEmpty() ? baseUrl : baseUrl + (String)(path.startsWith("/") ? path : "/" + path);
    }

    private Response responseFrom(HttpResponse response) throws AlexandriaException {
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                throw this.exception(statusCode, this.bodyContent(response));
            }
            return new RestResponse(statusCode, response.getAllHeaders(), response.getEntity().getContent());
        }
        catch (IOException e) {
            return new RestResponse(response.getStatusLine().getStatusCode(), response.getAllHeaders(), null);
        }
    }

    private AlexandriaException exception(int statusCode, String bodyContent) {
        AlexandriaException e;
        AlexandriaException alexandriaException = e = bodyContent.startsWith("{") ? (AlexandriaException)((Object)Json.fromString((String)bodyContent, AlexandriaException.class)) : null;
        if (e != null) {
            return ExceptionFactory.from((int)statusCode, (String)e.getMessage(), (Map)e.parameters());
        }
        return ExceptionFactory.from((int)statusCode, (String)bodyContent, Map.of());
    }

    private String bodyContent(HttpResponse response) {
        try {
            InputStream content = response.getEntity().getContent();
            return IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return "";
        }
    }

    public static class RestResponse
    implements Response {
        private final int code;
        private final InputStream content;
        private final Map<String, String> headers;

        public RestResponse(int code, Header[] headers, InputStream content) {
            this.code = code;
            this.headers = Arrays.stream(headers).flatMap(h -> Arrays.stream(h.getElements())).collect(Collectors.toMap(HeaderElement::getName, HeaderElement::getValue));
            this.content = content;
        }

        @Override
        public int code() {
            return this.code;
        }

        @Override
        public Map<String, String> headers() {
            return this.headers;
        }

        @Override
        public String contentType() {
            return this.headers.get("Content-Type");
        }

        @Override
        public String content() {
            try {
                return IOUtils.toString((InputStream)this.content, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public InputStream contentAsStream() {
            return this.content;
        }
    }

    public static interface Request {
        public Response execute() throws AlexandriaException;
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        PATCH,
        DELETE;

    }

    private static enum Auth {
        Basic,
        Bearer;

        private String token;

        Auth with(String token) {
            this.token = token;
            return this;
        }

        public String token() {
            return this.token;
        }
    }
}

