/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.restaccessor;

import io.intino.alexandria.Json;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.restaccessor.RequestBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class OutBox {
    private static final String JSON = ".json";
    protected final File directory;
    protected List<File> files;

    public OutBox(File directory, int retryIntervalSeconds) {
        this.directory = directory;
        this.reloadOutBox();
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.scheduleAtFixedRate(this::retry, 15L, retryIntervalSeconds, TimeUnit.SECONDS);
    }

    private void retry() {
        RequestBuilder.Request peek = this.peek();
        if (peek != null) {
            try {
                peek.execute();
                this.pop();
            }
            catch (AlexandriaException e) {
                Logger.error((Throwable)e);
            }
        }
    }

    public void push(RequestBuilder.Request request) {
        try {
            File file = new File(this.directory, UUID.randomUUID().toString() + JSON);
            Files.write(file.toPath(), request.toString().getBytes(), new OpenOption[0]);
            this.files.add(file);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private RequestBuilder.Request peek() {
        String requestContent = this.get();
        if (requestContent == null) {
            return null;
        }
        return ((RequestBuilder)Json.fromString((String)requestContent, RequestBuilder.class)).build();
    }

    private String get() {
        if (this.files.isEmpty()) {
            this.reloadOutBox();
        }
        if (this.files.isEmpty()) {
            return null;
        }
        try {
            File file = this.files.get(0);
            if (!file.exists()) {
                this.files.remove(file);
                return null;
            }
            return Files.readString(file.toPath());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private void pop() {
        this.reloadOutBox();
        if (this.files.isEmpty()) {
            return;
        }
        this.files.get(0).delete();
        this.files.remove(0);
    }

    private synchronized void reloadOutBox() {
        if (this.files.isEmpty()) {
            this.files = new ArrayList<File>(Arrays.asList(Objects.requireNonNull(this.directory.listFiles(f -> f.getName().endsWith(JSON)))));
            this.files.sort(Comparator.comparingLong(File::lastModified));
        }
    }
}

