/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.proxy;

import io.intino.alexandria.http.server.AlexandriaHttpRequest;
import io.intino.alexandria.http.server.AlexandriaHttpResponse;
import io.intino.alexandria.proxy.Network;
import io.intino.alexandria.proxy.ProxyAdapter;
import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class Proxy {
    private URL localUrl;
    private URL remoteUrl;
    private ProxyAdapter adapter = null;
    private static final Set<String> ValidHeaders = Set.of("X-Requested-With", "Accept", "Accept-Encoding", "Accept-Language", "Cache-Control", "Connections", "User-Agent");

    public Proxy(URL localUrl, URL remoteUrl) {
        this.localUrl = localUrl;
        this.remoteUrl = remoteUrl;
    }

    public Proxy adapter(ProxyAdapter adapter) {
        this.adapter = adapter;
        return this;
    }

    public void get(AlexandriaHttpRequest request, AlexandriaHttpResponse response) throws Network.NetworkException, URISyntaxException {
        Network network = new Network();
        Object query = request.queryString();
        query = query == null ? "" : "?" + (String)query;
        String uri = this.pathOf(request);
        String url = String.valueOf(this.remoteUrl) + uri + (String)query;
        network.setAdditionalHeaders(new ArrayList<NameValuePair>(this.validHeaders(request.headers()).map(h -> this.headerOf((String)h, request.header(h))).collect(Collectors.toList())));
        byte[] content = network.sendGetString(url);
        this.fixHeaders(network, response);
        content = this.adaptText(network, request, this.remoteUrl, uri, content);
        this.writeResponse(response, content);
    }

    private byte[] adaptText(Network network, AlexandriaHttpRequest request, URL remoteUrl, String uri, byte[] content) {
        if (!this.isText(network)) {
            return content;
        }
        String textContent = new String(content, StandardCharsets.UTF_8);
        if (this.isHtml(network)) {
            if (!request.uri().contains("iframe.html")) {
                textContent = this.adaptUrls(textContent, this.localUrl, remoteUrl, "src");
            }
            textContent = this.adaptUrls(textContent, this.localUrl, remoteUrl, "href");
        }
        if (this.isCss(network)) {
            String subUri = uri.length() > 1 ? uri.substring(1) : uri;
            Path path = Paths.get(uri.substring(0, subUri.lastIndexOf("/") + 1), new String[0]).getParent();
            textContent = textContent.replaceAll("url\\(\\.\\./", "url(" + String.valueOf(this.localUrl) + path.toString().replaceAll("\\\\", "/") + "/");
        }
        return this.adaptContent(textContent).getBytes();
    }

    private String adaptUrls(String content, URL localUrl, URL remoteUrl, String pattern) {
        content = content.replaceAll(" " + pattern + "=\"\\/\\/", " " + pattern + "_keep=\"//");
        content = content.replaceAll(" " + pattern + "=\"" + String.valueOf(remoteUrl), " " + pattern + "_keep=\"" + String.valueOf(localUrl));
        content = content.replaceAll(" " + pattern + "=\"/", " " + pattern + "=\"" + String.valueOf(localUrl) + "/");
        content = content.replaceAll(" " + pattern + "=\"./", " " + pattern + "=\"" + String.valueOf(localUrl) + "/./");
        content = content.replaceAll(" " + pattern + "_keep=", " " + pattern + "=");
        return content;
    }

    private boolean isText(Network network) {
        return this.isHtml(network) || this.isCss(network);
    }

    private boolean isHtml(Network network) {
        String contentType = this.contentType(network);
        return contentType != null && contentType.contains("text/html");
    }

    private boolean isCss(Network network) {
        String contentType = this.contentType(network);
        return contentType != null && contentType.contains("text/css");
    }

    private boolean isJs(Network network) {
        String contentType = this.contentType(network);
        return contentType != null && (contentType.contains("text/javascript") || contentType.contains("application/javascript"));
    }

    public void post(AlexandriaHttpRequest request, AlexandriaHttpResponse response) throws Network.NetworkException {
        Network network = new Network();
        Object query = request.queryString();
        query = query == null ? "" : "?" + (String)query;
        String url = String.valueOf(this.remoteUrl) + this.pathOf(request) + (String)query;
        StringBuilder params = new StringBuilder();
        for (String key : request.queryParams()) {
            String value = request.queryParam(key);
            params.append("&").append(key).append("=").append(this.adaptParameter(key, value));
        }
        if (params.length() > 0) {
            params = new StringBuilder(params.substring(1));
        }
        network.setAdditionalHeaders(new ArrayList<NameValuePair>(this.validHeaders(request.headers()).map(h -> this.headerOf((String)h, request.header(h))).collect(Collectors.toList())));
        byte[] content = network.sendPostString(url, params.toString());
        this.fixHeaders(network, response);
        content = this.adaptText(network, request, this.remoteUrl, this.pathOf(request), content);
        this.writeResponse(response, content);
    }

    private Stream<String> validHeaders(Map<String, String> headers) {
        return headers.keySet().stream().filter(ValidHeaders::contains);
    }

    private NameValuePair headerOf(String header, String value) {
        return new BasicNameValuePair(header, value);
    }

    private void fixHeaders(Network network, AlexandriaHttpResponse response) {
        response.removeCookie("JSESSIONID");
        Header[] headers = network.getLastHeaders();
        if (headers == null) {
            return;
        }
        for (Header header : headers) {
            if ("content-length".equalsIgnoreCase(header.getName()) || "Set-Cookie".equalsIgnoreCase(header.getName())) continue;
            response.header(header.getName(), header.getValue());
        }
    }

    private String contentType(Network network) {
        Header[] headers = network.getLastHeaders();
        if (headers == null) {
            return null;
        }
        for (Header header : headers) {
            if (!"content-type".equalsIgnoreCase(header.getName())) continue;
            return header.getValue();
        }
        return null;
    }

    private String pathOf(AlexandriaHttpRequest request) {
        String uri = this.format(request.uri());
        String path = this.removeAddressPath(request, this.localUrl.getPath());
        uri = uri.replace(path, "");
        uri = uri.replace(path.substring(0, path.lastIndexOf("/")), "");
        return uri;
    }

    private String format(String uri) {
        return uri.startsWith("//") ? uri.substring(1) : uri;
    }

    private String removeAddressPath(AlexandriaHttpRequest request, String path) {
        String header = request.raw().getHeader("X-Forwarded-Path");
        if (header == null) {
            return path;
        }
        return path.replace(header, "");
    }

    private String adaptParameter(String key, String value) {
        if (this.adapter == null) {
            return value;
        }
        return this.adapter.adaptParameter(this.localUrl, this.remoteUrl, key, value);
    }

    private String adaptContent(String content) {
        if (this.adapter == null) {
            return content;
        }
        return this.adapter.adaptContent(content);
    }

    private void writeResponse(AlexandriaHttpResponse response, byte[] content) throws Network.NetworkException {
        try {
            ServletOutputStream stream = response.raw().getOutputStream();
            response.raw().setContentLength(content.length);
            stream.write(content);
            stream.close();
        }
        catch (IOException e) {
            throw new Network.NetworkException(e);
        }
    }
}

