/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.proxy;

import io.intino.alexandria.proxy.Network;
import io.intino.alexandria.proxy.ProxyAdapter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletOutputStream;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import spark.Request;
import spark.Response;

public class Proxy {
    private URL localUrl;
    private URL remoteUrl;
    private ProxyAdapter adapter = null;
    private static final Set<String> ValidHeaders = Set.of("X-Requested-With");

    public Proxy(URL localUrl, URL remoteUrl) {
        this.localUrl = localUrl;
        this.remoteUrl = remoteUrl;
    }

    public Proxy adapter(ProxyAdapter adapter) {
        this.adapter = adapter;
        return this;
    }

    public void get(Request request, Response response) throws Network.NetworkException, URISyntaxException {
        Network network = new Network();
        Object query = request.queryString();
        query = query == null ? "" : "?" + (String)query;
        String uri = this.pathOf(request);
        String url = this.remoteUrl + uri + (String)query;
        network.setAdditionalHeaders(new ArrayList<NameValuePair>(this.validHeaders(request.headers()).map(h -> this.headerOf((String)h, request.headers(h))).collect(Collectors.toList())));
        byte[] content = network.sendGetString(url);
        this.fixHeaders(network, response);
        content = this.adaptText(network, request, this.remoteUrl, uri, content);
        this.writeResponse(response, content);
    }

    private byte[] adaptText(Network network, Request request, URL remoteUrl, String uri, byte[] content) {
        if (!this.isText(network)) {
            return content;
        }
        String textContent = new String(content, StandardCharsets.UTF_8);
        if (this.isHtml(network)) {
            if (!request.uri().contains("iframe.html")) {
                textContent = this.adaptUrls(textContent, this.localUrl, remoteUrl, "src");
            }
            textContent = this.adaptUrls(textContent, this.localUrl, remoteUrl, "href");
        }
        if (this.isCss(network)) {
            String subUri = uri.length() > 1 ? uri.substring(1) : uri;
            Path path = Paths.get(uri.substring(0, subUri.lastIndexOf("/") + 1), new String[0]).getParent();
            textContent = textContent.replaceAll("url\\(\\.\\./", "url(" + this.localUrl + path.toString().replaceAll("\\\\", "/") + "/");
        }
        return this.adaptContent(textContent).getBytes();
    }

    private String adaptUrls(String content, URL localUrl, URL remoteUrl, String pattern) {
        content = content.replaceAll(" " + pattern + "=\"\\/\\/", " " + pattern + "_keep=\"//");
        content = content.replaceAll(" " + pattern + "=\"" + remoteUrl, " " + pattern + "_keep=\"" + localUrl);
        content = content.replaceAll(" " + pattern + "=\"/", " " + pattern + "=\"" + localUrl + "/");
        content = content.replaceAll(" " + pattern + "=\"./", " " + pattern + "=\"" + localUrl + "/./");
        content = content.replaceAll(" " + pattern + "_keep=", " " + pattern + "=");
        return content;
    }

    private boolean isText(Network network) {
        return this.isHtml(network) || this.isCss(network);
    }

    private boolean isHtml(Network network) {
        String contentType = this.contentType(network);
        return contentType != null && contentType.contains("text/html");
    }

    private boolean isCss(Network network) {
        String contentType = this.contentType(network);
        return contentType != null && contentType.contains("text/css");
    }

    private boolean isJs(Network network) {
        String contentType = this.contentType(network);
        return contentType != null && (contentType.contains("text/javascript") || contentType.contains("application/javascript"));
    }

    public void post(Request request, Response response) throws Network.NetworkException {
        Network network = new Network();
        Object query = request.queryString();
        query = query == null ? "" : "?" + (String)query;
        String url = this.remoteUrl + this.pathOf(request) + (String)query;
        StringBuilder params = new StringBuilder();
        for (String key : request.queryParams()) {
            String value = request.queryParams(key);
            params.append("&").append(key).append("=").append(this.adaptParameter(key, value));
        }
        if (params.length() > 0) {
            params = new StringBuilder(params.substring(1));
        }
        network.setAdditionalHeaders(new ArrayList<NameValuePair>(this.validHeaders(request.headers()).map(h -> this.headerOf((String)h, request.headers(h))).collect(Collectors.toList())));
        byte[] content = network.sendPostString(url, params.toString());
        this.fixHeaders(network, response);
        content = this.adaptText(network, request, this.remoteUrl, this.pathOf(request), content);
        this.writeResponse(response, content);
    }

    private Stream<String> validHeaders(Set<String> headers) {
        return headers.stream().filter(ValidHeaders::contains);
    }

    private NameValuePair headerOf(String header, String value) {
        return new BasicNameValuePair(header, value);
    }

    private void fixHeaders(Network network, Response response) {
        response.removeCookie("JSESSIONID");
        Header[] headers = network.getLastHeaders();
        if (headers == null) {
            return;
        }
        for (Header header : headers) {
            if ("content-length".equalsIgnoreCase(header.getName()) || "Set-Cookie".equalsIgnoreCase(header.getName())) continue;
            response.header(header.getName(), header.getValue());
        }
    }

    private String contentType(Network network) {
        Header[] headers = network.getLastHeaders();
        if (headers == null) {
            return null;
        }
        for (Header header : headers) {
            if (!"content-type".equalsIgnoreCase(header.getName())) continue;
            return header.getValue();
        }
        return null;
    }

    private String pathOf(Request request) {
        String uri = this.format(request.uri());
        String path = this.removeAddressPath(request, this.localUrl.getPath());
        uri = uri.replace(path, "");
        uri = uri.replace(path.substring(0, path.lastIndexOf("/")), "");
        return uri;
    }

    private String format(String uri) {
        return uri.startsWith("//") ? uri.substring(1) : uri;
    }

    private String removeAddressPath(Request request, String path) {
        String header = request.raw().getHeader("X-Forwarded-Path");
        if (header == null) {
            return path;
        }
        return path.replace(header, "");
    }

    private String adaptParameter(String key, String value) {
        if (this.adapter == null) {
            return value;
        }
        return this.adapter.adaptParameter(this.localUrl, this.remoteUrl, key, value);
    }

    private String adaptContent(String content) {
        if (this.adapter == null) {
            return content;
        }
        return this.adapter.adaptContent(content);
    }

    private void writeResponse(Response response, byte[] content) throws Network.NetworkException {
        try {
            ServletOutputStream stream = response.raw().getOutputStream();
            response.raw().setContentLength(content.length);
            stream.write(content);
            stream.close();
        }
        catch (IOException e) {
            throw new Network.NetworkException(e);
        }
    }
}

