/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.proxy;

import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class Network {
    private List<String> cookies = new ArrayList<String>();
    private String referer = "";
    private String location = "";
    private Integer responseCode = 0;
    private String userAgent = "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:38.0) Gecko/20100101 Firefox/38.0";
    private String acceptLanguage = "en-US,en;q=0.5";
    private ArrayList<NameValuePair> headers = null;
    private Header[] lastHeaders = null;

    public byte[] sendPostString(String url, String postParams) throws NetworkException {
        try {
            return this.sendPost(url, postParams, null);
        }
        catch (Exception e) {
            throw new NetworkException(e);
        }
    }

    public byte[] sendPostString(String url, String postParams, ArrayList<NameValuePair> files) throws NetworkException {
        try {
            return this.sendPost(url, postParams, files);
        }
        catch (Exception e) {
            throw new NetworkException(e);
        }
    }

    private byte[] sendPost(String url, String postParams, ArrayList<NameValuePair> files) throws NetworkException {
        this.lastHeaders = null;
        SSLContextBuilder builder = new SSLContextBuilder();
        try {
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
            CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            HttpPost post = new HttpPost(url);
            this.addHeaders((HttpRequestBase)post);
            if (this.headers != null) {
                for (NameValuePair header : this.headers) {
                    post.addHeader(header.getName(), header.getValue());
                }
            }
            ArrayList<NameValuePair> parameters = this.convertQueryToArrayList(postParams);
            if (files == null) {
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
            } else {
                MultipartEntityBuilder builderEntity = MultipartEntityBuilder.create();
                for (NameValuePair parameter : parameters) {
                    builderEntity.addTextBody(parameter.getName(), parameter.getValue());
                }
                for (NameValuePair file : files) {
                    builderEntity.addPart(file.getName(), (ContentBody)new FileBody(new File(file.getValue())));
                }
                post.setEntity(builderEntity.build());
            }
            HttpResponse httpResp = this.executeSend(client, (HttpRequestBase)post);
            this.lastHeaders = httpResp.getAllHeaders();
            Logger.debug((String)("Sending 'POST' request to URL : " + url));
            Logger.debug((String)("Response Code : " + this.responseCode));
            if (httpResp.getHeaders("Content-Type").length > 0) {
                Logger.debug((String)(httpResp.getHeaders("Content-Type")[0].getName() + ": " + httpResp.getHeaders("Content-Type")[0].getValue()));
            } else {
                Logger.debug((String)"Content-Type: none");
            }
            Boolean redirect = this.isRedirect(this.responseCode, url);
            if (redirect.booleanValue()) {
                return this.sendGet(this.location);
            }
            return IOUtils.toByteArray((InputStream)httpResp.getEntity().getContent());
        }
        catch (Exception e) {
            throw new NetworkException(e);
        }
    }

    public byte[] sendGetString(String url) throws NetworkException {
        return this.sendGet(url);
    }

    private byte[] sendGet(String url) throws NetworkException {
        this.lastHeaders = null;
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
            RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("default").build();
            CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultRequestConfig(globalConfig).build();
            RequestConfig localConfig = RequestConfig.copy((RequestConfig)globalConfig).setCookieSpec("standard").build();
            HttpGet get = new HttpGet(url);
            get.setConfig(localConfig);
            this.addHeaders((HttpRequestBase)get);
            HttpResponse httpResp = this.executeSend(client, (HttpRequestBase)get);
            this.lastHeaders = httpResp.getAllHeaders();
            Logger.debug((String)("Sending 'GET' request to URL : " + url));
            Logger.debug((String)("Response Code : " + this.responseCode));
            if (httpResp.getHeaders("Content-Type").length > 0) {
                Logger.debug((String)(httpResp.getHeaders("Content-Type")[0].getName() + ": " + httpResp.getHeaders("Content-Type")[0].getValue()));
            } else {
                Logger.debug((String)"Content-Type: none");
            }
            if (this.responseCode > 400) {
                String message = String.format("Can't download file %s, Response code: %d, Message: %s", url, this.responseCode, IOUtils.toString((InputStream)httpResp.getEntity().getContent()));
                Logger.error((String)message);
                throw new NetworkException(message);
            }
            Boolean redirect = this.isRedirect(this.responseCode, url);
            if (redirect.booleanValue()) {
                return this.sendGet(this.location);
            }
            return IOUtils.toByteArray((InputStream)httpResp.getEntity().getContent());
        }
        catch (Exception e) {
            throw new NetworkException(e);
        }
    }

    public void download(String url, String fileName) throws IOException {
        URL website = new URL(url);
        ReadableByteChannel rbc = Channels.newChannel(website.openStream());
        FileOutputStream fos = new FileOutputStream(fileName);
        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
    }

    public String download(String url) throws NetworkException {
        return new String(this.sendGet(url));
    }

    public byte[] downloadBytes(String url) throws NetworkException {
        return this.sendGet(url);
    }

    private ArrayList<NameValuePair> convertQueryToArrayList(String query) throws UnsupportedEncodingException {
        String[] parameters;
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        for (String parameter : parameters = query.split("&")) {
            String[] param = parameter.split("=");
            String name = param[0];
            String value = "";
            if (param.length > 1) {
                value = URLDecoder.decode(param[1], "UTF-8");
            }
            result.add((NameValuePair)new BasicNameValuePair(name, value));
        }
        return result;
    }

    private String getCookiesAsString() {
        StringBuilder cookiesBuffer = new StringBuilder();
        for (String cookieFull : this.cookies) {
            String cookie = cookieFull.substring(0, cookieFull.indexOf(";") + 1);
            cookiesBuffer.append(cookie).append(" ");
        }
        String result = cookiesBuffer.toString();
        if (result.length() > 0) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    public void addCookie(String name, String value) {
        this.cookies.add(name + "=" + value + ";");
    }

    private void setCookies(Header[] headers) {
        for (Header h : headers) {
            String cookieFull = h.getValue();
            this.removeCookie(this.getCookieName(cookieFull));
            this.cookies.add(cookieFull);
        }
    }

    private void removeCookie(String name) {
        ArrayList<String> newcookies = new ArrayList<String>();
        for (String cookie : this.cookies) {
            if (name.equals(this.getCookieName(cookie))) continue;
            newcookies.add(cookie);
        }
        this.cookies = newcookies;
    }

    private String getCookieName(String cookieFull) {
        String[] fields = cookieFull.split(";\\s*")[0].split("=");
        return fields[0];
    }

    public String getCookieValue(String name) {
        String result = "";
        for (String cookie : this.cookies) {
            String[] fields = cookie.split(";\\s*")[0].split("=");
            if (!name.equals(fields[0])) continue;
            result = fields[1];
        }
        return result;
    }

    public List<String> getCookies() {
        return this.cookies;
    }

    public Integer getLastResultCode() {
        return this.responseCode;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public void setAgent(String agent) {
        this.userAgent = agent;
    }

    public String getRemoteIP() {
        try {
            return new String(this.sendGetString("http://wtfismyip.com/text"), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            Logger.debug((String)e.getMessage());
            return "";
        }
    }

    public String getDomainIP(String domain) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(domain);
        return address.getHostAddress();
    }

    public void setAdditionalHeaders(ArrayList<NameValuePair> headers) {
        this.headers = headers;
    }

    public Header[] getLastHeaders() {
        return this.lastHeaders;
    }

    private void addHeaders(HttpRequestBase entity) {
        entity.addHeader("User-Agent", this.userAgent);
        entity.addHeader("Accept-Language", this.acceptLanguage);
        entity.addHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        entity.addHeader("Connection", "keep-alive");
        entity.addHeader("Cookie", this.getCookiesAsString());
        entity.addHeader("referer", this.referer);
    }

    private Boolean isRedirect(Integer responseCode, String url) {
        if (responseCode < 300) {
            this.referer = url;
        }
        boolean redirect = false;
        if (responseCode != 200 && (responseCode == 302 || responseCode == 301 || responseCode == 303)) {
            redirect = true;
        }
        return redirect;
    }

    private HttpResponse executeSend(CloseableHttpClient client, HttpRequestBase entity) throws IOException {
        CloseableHttpResponse httpResp = client.execute((HttpUriRequest)entity);
        this.responseCode = httpResp.getStatusLine().getStatusCode();
        if (httpResp.getHeaders("Set-Cookie").length > 0) {
            this.setCookies(httpResp.getHeaders("Set-Cookie"));
        }
        this.location = "";
        if (httpResp.getHeaders("Location").length > 0) {
            this.location = httpResp.getHeaders("Location")[0].getValue();
        }
        return httpResp;
    }

    public static class NetworkException
    extends Exception {
        NetworkException(String message) {
            super(message);
        }

        NetworkException(Throwable cause) {
            super(cause);
        }
    }
}

