/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.office;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;

public class PdfMerger {
    private final List<File> pdfsToMerge = new ArrayList<File>();
    private boolean useOnlyTempFiles = false;

    public PdfMerger append(File pdfFile) {
        if (pdfFile == null) {
            throw new NullPointerException("PDF file cannot be null");
        }
        this.pdfsToMerge.add(pdfFile);
        return this;
    }

    public int size() {
        return this.pdfsToMerge.size();
    }

    public void merge(File destinationPdf) throws IOException {
        if (this.size() == 0) {
            throw new NoSuchFileException("No pdfs to merge");
        }
        PDFMergerUtility merger = new PDFMergerUtility();
        merger.setDocumentMergeMode(PDFMergerUtility.DocumentMergeMode.OPTIMIZE_RESOURCES_MODE);
        merger.setDestinationFileName(destinationPdf.getAbsolutePath());
        for (File pdf : this.pdfsToMerge) {
            merger.addSource(pdf);
        }
        merger.mergeDocuments(this.getMemoryUsageSettings());
    }

    private MemoryUsageSetting getMemoryUsageSettings() {
        return this.useOnlyTempFiles ? MemoryUsageSetting.setupTempFileOnly() : MemoryUsageSetting.setupMainMemoryOnly();
    }

    public PdfMerger useOnlyTempFiles(boolean useOnlyTempFiles) {
        this.useOnlyTempFiles = useOnlyTempFiles;
        return this;
    }
}

