/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.office;

import io.intino.alexandria.office.PdfMetadata;
import io.intino.alexandria.office.PdfOverlay;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import org.apache.pdfbox.multipdf.Overlay;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PdfDecorator {
    private final File pdf;
    private PdfMetadata metadata;
    private PdfOverlay overlay;

    public PdfDecorator(File pdf) {
        this.pdf = pdf;
    }

    public void save(File destination) throws IOException {
        File sourcePdf = this.overlay == null ? this.pdf : this.applyOverlay();
        try (PDDocument document = PDDocument.load((File)sourcePdf);){
            if (this.metadata != null) {
                document.setDocumentInformation(this.metadata.info());
            }
            document.save(destination);
        }
    }

    private File applyOverlay() throws IOException {
        File temp = File.createTempFile("alexandria.office.pdfdecorator", ".pdf");
        temp.deleteOnExit();
        try (PDDocument sourceDocument = PDDocument.load((File)this.pdf);
             Overlay overlayApplier = new Overlay();){
            overlayApplier.setInputPDF(sourceDocument);
            Optional.ofNullable(this.overlay.get(PdfOverlay.Target.DEFAULT)).map(File::getAbsolutePath).ifPresent(arg_0 -> ((Overlay)overlayApplier).setDefaultOverlayFile(arg_0));
            Optional.ofNullable(this.overlay.get(PdfOverlay.Target.ALL_PAGES)).map(File::getAbsolutePath).ifPresent(arg_0 -> ((Overlay)overlayApplier).setAllPagesOverlayFile(arg_0));
            Optional.ofNullable(this.overlay.get(PdfOverlay.Target.FIRST_PAGE)).map(File::getAbsolutePath).ifPresent(arg_0 -> ((Overlay)overlayApplier).setFirstPageOverlayFile(arg_0));
            Optional.ofNullable(this.overlay.get(PdfOverlay.Target.LAST_PAGE)).map(File::getAbsolutePath).ifPresent(arg_0 -> ((Overlay)overlayApplier).setLastPageOverlayFile(arg_0));
            Optional.ofNullable(this.overlay.get(PdfOverlay.Target.EVEN_PAGES)).map(File::getAbsolutePath).ifPresent(arg_0 -> ((Overlay)overlayApplier).setEvenPageOverlayFile(arg_0));
            Optional.ofNullable(this.overlay.get(PdfOverlay.Target.ODD_PAGES)).map(File::getAbsolutePath).ifPresent(arg_0 -> ((Overlay)overlayApplier).setOddPageOverlayFile(arg_0));
            overlayApplier.setOverlayPosition(this.overlay.position() == PdfOverlay.Position.FOREGROUND ? Overlay.Position.FOREGROUND : Overlay.Position.BACKGROUND);
            try (PDDocument outputDocument = overlayApplier.overlay(Collections.emptyMap());){
                outputDocument.save(temp);
            }
        }
        return temp;
    }

    public PdfDecorator setMetadata(PdfMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public PdfDecorator setOverlay(PdfOverlay overlay) {
        this.overlay = overlay;
        return this;
    }
}

