/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.office;

import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.pdf.PdfConverter;
import fr.opensagres.poi.xwpf.converter.pdf.PdfOptions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class PdfBuilder {
    private final SourceDocx inputDocx;
    private final Backend backend;

    public static PdfBuilder create(File file) {
        return new PdfBuilder(file, (Backend)new ApachePOIBackend());
    }

    public static PdfBuilder create(File file, Backend backend) {
        return new PdfBuilder(file, backend);
    }

    public static PdfBuilder create(InputStream inputStream) {
        return new PdfBuilder(inputStream, (Backend)new ApachePOIBackend());
    }

    public static PdfBuilder create(InputStream inputStream, Backend backend) {
        return new PdfBuilder(SourceDocx.of(inputStream), backend);
    }

    public static PdfBuilder create(byte[] bytes) {
        return new PdfBuilder(bytes, (Backend)new ApachePOIBackend());
    }

    public static PdfBuilder create(byte[] bytes, Backend backend) {
        return new PdfBuilder(SourceDocx.of(bytes), backend);
    }

    public PdfBuilder(File file) {
        this(file, (Backend)new ApachePOIBackend());
    }

    public PdfBuilder(File file, Backend backend) {
        this(SourceDocx.of(file), backend);
    }

    public PdfBuilder(InputStream inputStream) {
        this(inputStream, (Backend)new ApachePOIBackend());
    }

    public PdfBuilder(InputStream inputStream, Backend backend) {
        this(SourceDocx.of(inputStream), backend);
    }

    public PdfBuilder(byte[] bytes) {
        this(bytes, (Backend)new ApachePOIBackend());
    }

    public PdfBuilder(byte[] bytes, Backend backend) {
        this(SourceDocx.of(bytes), backend);
    }

    public PdfBuilder(SourceDocx inputDocx, Backend backend) {
        this.inputDocx = inputDocx;
        this.backend = Objects.requireNonNull(backend);
    }

    public void save(File destinationPDF) throws IOException {
        this.backend.save(this.inputDocx, destinationPDF);
    }

    public static class ApachePOIBackend
    implements Backend {
        @Override
        public void save(SourceDocx inputDocx, File destinationPDF) throws IOException {
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destinationPDF));
                 BufferedInputStream doc = new BufferedInputStream(inputDocx.open());){
                XWPFDocument document = new XWPFDocument((InputStream)doc);
                PdfOptions options = PdfOptions.getDefault();
                PdfConverter.getInstance().convert(document, (OutputStream)out, (Options)options);
            }
        }
    }

    public static interface Backend {
        public void save(SourceDocx var1, File var2) throws IOException;
    }

    @FunctionalInterface
    public static interface SourceDocx {
        public InputStream open() throws IOException;

        public static SourceDocx of(File file) {
            return () -> new FileInputStream(file);
        }

        public static SourceDocx of(InputStream inputStream) {
            return () -> inputStream;
        }

        public static SourceDocx of(byte[] bytes) {
            return () -> new ByteArrayInputStream(bytes);
        }
    }
}

