/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ollama.responses;

import com.google.gson.annotations.SerializedName;
import io.intino.alexandria.ollama.responses.OllamaResponse;

public class OllamaGenerateResponse
extends OllamaResponse {
    private String model;
    @SerializedName(value="created_at")
    private String createdAt;
    private String response;
    private String thinking;
    private boolean done;
    private int[] context;
    @SerializedName(value="total_duration")
    private long totalDuration;
    @SerializedName(value="load_duration")
    private long loadDuration;
    @SerializedName(value="prompt_eval_count")
    private long promptEvalCount;
    @SerializedName(value="prompt_eval_duration")
    private long promptEvalDuration;
    @SerializedName(value="eval_count")
    private long evalCount;
    @SerializedName(value="eval_duration")
    private long evalDuration;

    public String model() {
        return this.model;
    }

    public OllamaGenerateResponse model(String model) {
        this.model = model;
        return this;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public OllamaGenerateResponse createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public String response() {
        return this.response;
    }

    public String text() {
        return this.response;
    }

    public String fullText() {
        return this.thinking == null || this.thinking.isBlank() ? this.response : "<think>\n%s\n</think>\n%s".formatted(this.thinking, this.response);
    }

    public OllamaGenerateResponse response(String response) {
        this.response = response;
        return this;
    }

    public String thinking() {
        return this.thinking;
    }

    public OllamaGenerateResponse thinking(String thinking) {
        this.thinking = thinking;
        return this;
    }

    public boolean done() {
        return this.done;
    }

    public OllamaGenerateResponse done(boolean done) {
        this.done = done;
        return this;
    }

    public int[] context() {
        return this.context;
    }

    public OllamaGenerateResponse context(int[] context) {
        this.context = context;
        return this;
    }

    public long totalDuration() {
        return this.totalDuration;
    }

    public OllamaGenerateResponse totalDuration(long totalDuration) {
        this.totalDuration = totalDuration;
        return this;
    }

    public long loadDuration() {
        return this.loadDuration;
    }

    public OllamaGenerateResponse loadDuration(long loadDuration) {
        this.loadDuration = loadDuration;
        return this;
    }

    public long promptEvalCount() {
        return this.promptEvalCount;
    }

    public OllamaGenerateResponse promptEvalCount(long promptEvalCount) {
        this.promptEvalCount = promptEvalCount;
        return this;
    }

    public long promptEvalDuration() {
        return this.promptEvalDuration;
    }

    public OllamaGenerateResponse promptEvalDuration(long promptEvalDuration) {
        this.promptEvalDuration = promptEvalDuration;
        return this;
    }

    public long evalCount() {
        return this.evalCount;
    }

    public OllamaGenerateResponse evalCount(long evalCount) {
        this.evalCount = evalCount;
        return this;
    }

    public long evalDuration() {
        return this.evalDuration;
    }

    public OllamaGenerateResponse evalDuration(long evalDuration) {
        this.evalDuration = evalDuration;
        return this;
    }

    public float tokensPerSecond() {
        return (float)this.evalCount / (float)this.evalDuration * 1.0E9f;
    }
}

