/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ollama.responses;

import com.google.gson.annotations.SerializedName;
import io.intino.alexandria.ollama.responses.OllamaResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public abstract class OllamaEmbedResponse<T>
extends OllamaResponse
implements Iterable<T> {
    private String model;
    @SerializedName(value="total_duration")
    private long totalDuration;
    @SerializedName(value="load_duration")
    private long loadDuration;
    @SerializedName(value="prompt_eval_count")
    private long promptEvalCount;

    public String model() {
        return this.model;
    }

    public OllamaEmbedResponse<T> model(String model) {
        this.model = model;
        return this;
    }

    public long totalDuration() {
        return this.totalDuration;
    }

    public OllamaEmbedResponse<T> totalDuration(long totalDuration) {
        this.totalDuration = totalDuration;
        return this;
    }

    public long loadDuration() {
        return this.loadDuration;
    }

    public OllamaEmbedResponse<T> loadDuration(long loadDuration) {
        this.loadDuration = loadDuration;
        return this;
    }

    public long promptEvalCount() {
        return this.promptEvalCount;
    }

    public OllamaEmbedResponse<T> promptEvalCount(long promptEvalCount) {
        this.promptEvalCount = promptEvalCount;
        return this;
    }

    public abstract T[] embeddings();

    public abstract OllamaEmbedResponse<T> embeddings(T[] var1);

    public static class OfFloat
    extends OllamaEmbedResponse<float[]> {
        private float[][] embeddings = new float[0][0];

        public OfFloat model(String model) {
            super.model(model);
            return this;
        }

        public float[][] embeddings() {
            return this.embeddings;
        }

        public List<List<Float>> embeddingsAsList() {
            ArrayList<List<Float>> list = new ArrayList<List<Float>>(this.embeddings.length);
            for (float[] vector : this.embeddings) {
                ArrayList<Float> boxed = new ArrayList<Float>(vector.length);
                for (float v : vector) {
                    boxed.add(Float.valueOf(v));
                }
                list.add(boxed);
            }
            return list;
        }

        public OfFloat embeddings(float[][] embeddings) {
            this.embeddings = embeddings;
            return this;
        }

        @Override
        public Iterator<float[]> iterator() {
            return Arrays.stream(this.embeddings).iterator();
        }
    }

    public static class OfDouble
    extends OllamaEmbedResponse<double[]> {
        private double[][] embeddings = new double[0][0];

        public OfDouble model(String model) {
            super.model(model);
            return this;
        }

        public double[][] embeddings() {
            return this.embeddings;
        }

        public List<List<Double>> embeddingsAsLists() {
            ArrayList<List<Double>> list = new ArrayList<List<Double>>(this.embeddings.length);
            for (double[] vector : this.embeddings) {
                list.add(Arrays.stream(vector).boxed().collect(Collectors.toList()));
            }
            return list;
        }

        public OfDouble embeddings(double[][] embeddings) {
            this.embeddings = embeddings;
            return this;
        }

        @Override
        public Iterator<double[]> iterator() {
            return Arrays.stream(this.embeddings).iterator();
        }
    }
}

