/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ollama;

import io.intino.alexandria.Json;
import io.intino.alexandria.ollama.Ollama;
import io.intino.alexandria.ollama.OllamaAPIException;
import io.intino.alexandria.ollama.requests.OllamaChatRequest;
import io.intino.alexandria.ollama.requests.OllamaCopyRequest;
import io.intino.alexandria.ollama.requests.OllamaCreateModelRequest;
import io.intino.alexandria.ollama.requests.OllamaEmbedRequest;
import io.intino.alexandria.ollama.requests.OllamaGenerateRequest;
import io.intino.alexandria.ollama.requests.OllamaPullRequest;
import io.intino.alexandria.ollama.requests.OllamaPushRequest;
import io.intino.alexandria.ollama.requests.OllamaRequest;
import io.intino.alexandria.ollama.requests.OllamaShowRequest;
import io.intino.alexandria.ollama.responses.OllamaChatResponse;
import io.intino.alexandria.ollama.responses.OllamaCreateModelResponse;
import io.intino.alexandria.ollama.responses.OllamaEmbedResponse;
import io.intino.alexandria.ollama.responses.OllamaGenerateResponse;
import io.intino.alexandria.ollama.responses.OllamaListResponse;
import io.intino.alexandria.ollama.responses.OllamaPsResponse;
import io.intino.alexandria.ollama.responses.OllamaPullResponse;
import io.intino.alexandria.ollama.responses.OllamaPushResponse;
import io.intino.alexandria.ollama.responses.OllamaResponse;
import io.intino.alexandria.ollama.responses.OllamaShowResponse;
import io.intino.alexandria.ollama.tools.OllamaTool;
import io.intino.alexandria.ollama.tools.OllamaToolCall;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class OllamaHttpClient
implements Ollama {
    private static final String DEFAULT_OLLAMA_BASE_URL = "http://localhost:11434";
    private final HttpClient httpClient;
    private final String baseUrl;
    private Duration timeout;
    private final Map<String, String> commonHeaders = new HashMap<String, String>();

    public OllamaHttpClient() {
        this(DEFAULT_OLLAMA_BASE_URL);
    }

    public OllamaHttpClient(String baseUrl) {
        this(baseUrl, Duration.of(5L, ChronoUnit.MINUTES), HttpClient.newHttpClient());
    }

    public OllamaHttpClient(String baseUrl, Duration timeout) {
        this(baseUrl, timeout, HttpClient.newHttpClient());
    }

    public OllamaHttpClient(String baseUrl, Duration timeout, HttpClient httpClient) {
        this.baseUrl = Objects.requireNonNull(baseUrl);
        this.timeout = timeout;
        this.httpClient = httpClient;
    }

    @Override
    public OllamaChatResponse chat(OllamaChatRequest chatRequest) throws OllamaAPIException {
        OllamaChatResponse response = this.call(this.post("/api/chat", chatRequest.stream(false)), OllamaChatResponse.class);
        if (chatRequest.tools() != null && response.message().hasToolCalls()) {
            for (OllamaToolCall toolCall : response.message().toolCalls()) {
                OllamaTool toolDefinition = chatRequest.tools().stream().filter(t -> t.function().name().equals(toolCall.function().name())).findFirst().orElse(null);
                if (toolDefinition == null) continue;
                toolCall.function().binding(toolDefinition.function().binding());
            }
        }
        return response;
    }

    @Override
    public Ollama.StreamResponse<OllamaChatResponse> chatStream(OllamaChatRequest chatRequest) throws OllamaAPIException {
        return this.callStream(this.post("/api/chat", chatRequest.stream(true)), OllamaChatResponse.class);
    }

    @Override
    public OllamaGenerateResponse generate(OllamaGenerateRequest generateRequest) throws OllamaAPIException {
        return this.call(this.post("/api/generate", generateRequest.stream(false)), OllamaGenerateResponse.class);
    }

    @Override
    public Ollama.StreamResponse<OllamaGenerateResponse> generateStream(OllamaGenerateRequest generateRequest) throws OllamaAPIException {
        return this.callStream(this.post("/api/generate", generateRequest.stream(true)), OllamaGenerateResponse.class);
    }

    @Override
    public OllamaEmbedResponse.OfDouble embed(OllamaEmbedRequest embedRequest) throws OllamaAPIException {
        return this.call(this.post("/api/embed", embedRequest), OllamaEmbedResponse.OfDouble.class);
    }

    @Override
    public OllamaEmbedResponse.OfFloat embedFloats(OllamaEmbedRequest embedRequest) throws OllamaAPIException {
        return this.call(this.post("/api/embed", embedRequest), OllamaEmbedResponse.OfFloat.class);
    }

    @Override
    public OllamaCreateModelResponse createModel(OllamaCreateModelRequest createModelRequest) throws OllamaAPIException {
        return this.call(this.post("/api/create", createModelRequest.stream(false)), OllamaCreateModelResponse.class);
    }

    @Override
    public Ollama.StreamResponse<OllamaCreateModelResponse> createModelStream(OllamaCreateModelRequest createModelRequest) throws OllamaAPIException {
        return this.callStream(this.post("/api/create", createModelRequest.stream(true)), OllamaCreateModelResponse.class);
    }

    @Override
    public OllamaListResponse list() throws OllamaAPIException {
        return this.call(this.get("/api/tags"), OllamaListResponse.class);
    }

    @Override
    public OllamaShowResponse show(OllamaShowRequest showRequest) throws OllamaAPIException {
        return this.call(this.post("/api/show", showRequest), OllamaShowResponse.class);
    }

    @Override
    public OllamaPullResponse pull(OllamaPullRequest pullRequest) throws OllamaAPIException {
        return this.call(this.post("/api/pull", pullRequest.stream(false)), OllamaPullResponse.class);
    }

    @Override
    public Ollama.StreamResponse<OllamaPullResponse> pullStream(OllamaPullRequest pullRequest) throws OllamaAPIException {
        return this.callStream(this.post("/api/pull", pullRequest.stream(true)), OllamaPullResponse.class);
    }

    @Override
    public OllamaPushResponse push(OllamaPushRequest pushRequest) throws OllamaAPIException {
        return this.call(this.post("/api/push", pushRequest.stream(true)), OllamaPushResponse.class);
    }

    @Override
    public Ollama.StreamResponse<OllamaPushResponse> pushStream(OllamaPushRequest pushRequest) throws OllamaAPIException {
        return this.callStream(this.post("/api/push", pushRequest.stream(true)), OllamaPushResponse.class);
    }

    @Override
    public OllamaPsResponse ps() throws OllamaAPIException {
        return this.call(this.get("/api/ps"), OllamaPsResponse.class);
    }

    @Override
    public void copy(OllamaCopyRequest copyRequest) throws OllamaAPIException {
        this.call(this.post("/api/copy", copyRequest));
    }

    @Override
    public void delete(String name) throws OllamaAPIException {
        this.call(this.deleteRequest("/api/delete", Json.toJson(Map.of("name", name))));
    }

    @Override
    public boolean existsBlob(String digest) throws OllamaAPIException {
        try {
            this.call(this.head("/api/blobs/sha256:" + digest));
            return true;
        }
        catch (OllamaAPIException e) {
            if (e.statusCode() != null && e.statusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public void createBlob(File file, String digest) throws OllamaAPIException, FileNotFoundException {
        this.call(this.post("/api/blobs/sha256:" + digest, file));
    }

    @Override
    public void createBlob(File file) throws OllamaAPIException, FileNotFoundException {
        this.call(this.post("/api/blobs/sha256:" + Ollama.sha256(file), file));
    }

    public <T extends OllamaResponse> T call(HttpRequest request, Class<T> responseType) throws OllamaAPIException {
        try {
            HttpResponse<String> httpResponse = this.sendRequest(request);
            return OllamaResponse.fromJson(httpResponse.body(), responseType);
        }
        catch (OllamaAPIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OllamaAPIException("Error when calling " + String.valueOf(request.uri()) + ": " + e.getMessage(), e);
        }
    }

    public void call(HttpRequest request) throws OllamaAPIException {
        try {
            this.sendRequest(request);
        }
        catch (OllamaAPIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OllamaAPIException("Error when calling " + String.valueOf(request.uri()) + ": " + e.getMessage(), e);
        }
    }

    private HttpResponse<String> sendRequest(HttpRequest request) throws IOException, InterruptedException, OllamaAPIException {
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        if (response.statusCode() < 200 || response.statusCode() > 299) {
            String msg = response.body();
            if (msg.contains("{\"error\":")) {
                msg = ((Map)Json.fromJson((String)msg, Map.class)).get("error").toString();
            }
            throw new OllamaAPIException(response.statusCode(), "Error (" + response.statusCode() + ") when calling " + String.valueOf(request.uri()) + ": " + msg);
        }
        return response;
    }

    public <T extends OllamaResponse> Ollama.StreamResponse<T> callStream(HttpRequest request, Class<T> responseType) throws OllamaAPIException {
        try {
            HttpResponse<InputStream> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() < 200 || response.statusCode() > 299) {
                InputStream body = response.body();
                try {
                    String msg;
                    String string = msg = body != null ? new String(body.readAllBytes(), StandardCharsets.UTF_8) : "";
                    if (msg.contains("{\"error\":")) {
                        msg = ((Map)Json.fromJson((String)msg, Map.class)).get("error").toString();
                    }
                    throw new OllamaAPIException(response.statusCode(), "Error (" + response.statusCode() + ") when calling " + String.valueOf(request.uri()) + ": " + msg);
                }
                catch (Throwable throwable) {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            return new Ollama.StreamResponse<T>(response.body(), responseType);
        }
        catch (OllamaAPIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OllamaAPIException("Error when calling " + String.valueOf(request.uri()) + ": " + e.getMessage(), e);
        }
    }

    private HttpRequest post(String endpoint, OllamaRequest ollamaRequest) {
        return this.request(endpoint).header("Content-Type", "application/json").timeout(this.timeout).POST(HttpRequest.BodyPublishers.ofString(ollamaRequest.toJson(), StandardCharsets.UTF_8)).build();
    }

    private HttpRequest post(String endpoint, File file) throws FileNotFoundException {
        return this.request(endpoint).header("Content-Type", "application/octet-stream").timeout(this.timeout).POST(HttpRequest.BodyPublishers.ofFile(file.toPath())).build();
    }

    private HttpRequest post(String endpoint) {
        return this.request(endpoint).header("Content-Type", "application/json").timeout(this.timeout).POST(HttpRequest.BodyPublishers.noBody()).build();
    }

    private HttpRequest get(String endpoint) {
        return this.request(endpoint).timeout(this.timeout).GET().build();
    }

    private HttpRequest head(String endpoint) {
        return this.request(endpoint).timeout(this.timeout).HEAD().build();
    }

    private HttpRequest deleteRequest(String endpoint, String body) {
        return this.request(endpoint).timeout(this.timeout).method("DELETE", HttpRequest.BodyPublishers.ofString(body, StandardCharsets.UTF_8)).build();
    }

    private HttpRequest.Builder request(String endpoint) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(this.baseUrl + endpoint));
        for (Map.Entry<String, String> entry : this.commonHeaders.entrySet()) {
            builder.setHeader(entry.getKey(), entry.getValue());
        }
        return builder;
    }

    @Override
    public String baseUrl() {
        return this.baseUrl;
    }

    @Override
    public Duration timeout() {
        return this.timeout;
    }

    @Override
    public OllamaHttpClient timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public Map<String, String> commonHeaders() {
        return Collections.unmodifiableMap(this.commonHeaders);
    }

    public OllamaHttpClient setCommonHeaders(Map<String, String> headers) {
        this.commonHeaders.clear();
        this.commonHeaders.putAll(headers);
        return this;
    }

    public String getCommonHeader(String name) {
        return this.commonHeaders.get(name);
    }

    @Override
    public OllamaHttpClient setCommonHeader(String name, String value) {
        this.commonHeaders.put(name, value);
        return this;
    }

    public OllamaHttpClient removeCommonHeader(String name) {
        this.commonHeaders.remove(name);
        return this;
    }

    @Override
    public void close() {
        this.httpClient.close();
    }
}

