/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ollama.tools;

import io.intino.alexandria.Json;
import io.intino.alexandria.ollama.tools.BadToolCallException;
import io.intino.alexandria.ollama.tools.BindingParseException;
import io.intino.alexandria.ollama.tools.OllamaFunction;
import io.intino.alexandria.ollama.tools.OllamaFunctionParamTypeMapper;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.Map;
import java.util.function.Function;

public class OllamaToolCallFunction {
    private String name;
    private Map<String, Object> arguments;
    private transient Class<?> binding;

    public OllamaToolCallFunction() {
    }

    public OllamaToolCallFunction(String name, Map<String, Object> arguments) {
        this.name = name;
        this.arguments = arguments;
    }

    public OllamaToolCallFunction(String name, Map<String, Object> arguments, Class<?> binding) {
        this.name = name;
        this.arguments = arguments;
        this.binding(binding);
    }

    public String name() {
        return this.name;
    }

    public OllamaToolCallFunction name(String name) {
        this.name = name;
        return this;
    }

    public Map<String, Object> arguments() {
        return this.arguments;
    }

    public OllamaToolCallFunction arguments(Map<String, Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    public <T> T binding() throws Exception {
        return this.binding(BindingParser.getDefaultParser());
    }

    public <T> T binding(BindingParser<T> parser) throws Exception {
        return parser.parse(this.bindingClass(), this.arguments);
    }

    public <T> Class<T> bindingClass() {
        return this.binding;
    }

    public OllamaToolCallFunction binding(Class<?> binding) {
        if (binding != null && binding.getAnnotation(OllamaFunction.Binding.class) == null) {
            throw new IllegalArgumentException("Binding object must be annotated with OllamaFunction.Binding annotation");
        }
        this.binding = binding;
        return this;
    }

    public String toString() {
        return Json.toJson((Object)this);
    }

    public static interface BindingParser<T> {
        public T parse(Class<T> var1, Map<String, Object> var2) throws BindingParseException;

        public static <T> BindingParser<T> getDefaultParser() {
            return BindingParser.getDefaultParser(FieldParser.getDefault());
        }

        public static <T> BindingParser<T> getDefaultParser(FieldParser fieldParser) {
            return (type, arguments) -> {
                try {
                    Constructor constructor;
                    if (type == null) {
                        return null;
                    }
                    try {
                        constructor = type.getDeclaredConstructor(new Class[0]);
                        constructor.setAccessible(true);
                    }
                    catch (NoSuchMethodException | InaccessibleObjectException e) {
                        throw new RuntimeException("Binding objects need to define an accessible constructor with no parameters", e);
                    }
                    Object instance = constructor.newInstance(new Object[0]);
                    for (Field field : type.getDeclaredFields()) {
                        boolean wasPrivate = field.accessFlags().contains((Object)AccessFlag.PRIVATE);
                        try {
                            String name;
                            field.setAccessible(true);
                            OllamaFunction.Param param = field.getAnnotation(OllamaFunction.Param.class);
                            if (param == null) continue;
                            String string = name = param.name().isBlank() ? field.getName() : param.name();
                            if (!arguments.containsKey(name)) {
                                if (!param.required()) continue;
                                throw new BadToolCallException("The parameter " + name + " was specified as required but is not set");
                            }
                            Object value = arguments.get(name);
                            if (value != null) {
                                field.set(instance, fieldParser.parse(name, value, field, param));
                                continue;
                            }
                            field.set(instance, null);
                        }
                        finally {
                            if (wasPrivate) {
                                field.setAccessible(false);
                            }
                        }
                    }
                    return instance;
                }
                catch (BindingParseException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BindingParseException(e);
                }
            };
        }

        public static interface FieldParser {
            public Object parse(String var1, Object var2, Field var3, OllamaFunction.Param var4) throws BindingParseException;

            public static FieldParser getDefault() {
                return (name, rawValue, field, paramDefinition) -> {
                    try {
                        boolean isArray = field.getType().isArray();
                        OllamaFunction.ParamType type = OllamaFunctionParamTypeMapper.mapToParamType(field);
                        return switch (type) {
                            case OllamaFunction.ParamType.STRING -> String.valueOf(rawValue);
                            case OllamaFunction.ParamType.INT -> FieldParser.parseInt(rawValue);
                            case OllamaFunction.ParamType.LONG -> FieldParser.parseLong(rawValue);
                            case OllamaFunction.ParamType.FLOAT -> FieldParser.parseFloat(rawValue);
                            case OllamaFunction.ParamType.DOUBLE -> FieldParser.parseDouble(rawValue);
                            case OllamaFunction.ParamType.CHAR -> FieldParser.parseChar(rawValue);
                            case OllamaFunction.ParamType.SHORT -> FieldParser.parseShort(rawValue);
                            case OllamaFunction.ParamType.BYTE -> FieldParser.parseByte(rawValue);
                            default -> isArray ? FieldParser.parseArray(field.getType(), rawValue) : FieldParser.parseCollection(field.getType(), rawValue);
                        };
                    }
                    catch (Exception e) {
                        throw new BindingParseException("Error while parsing field " + name + " from the raw value '" + String.valueOf(rawValue) + "' to " + String.valueOf(field.getType()) + ": " + e.getMessage(), e);
                    }
                };
            }

            public static Object parseArray(Class<?> type, Object rawValue) {
                return Json.fromJson((String)(rawValue instanceof CharSequence ? rawValue.toString() : Json.toJson((Object)rawValue)), type);
            }

            public static Object parseCollection(Class<?> type, Object rawValue) {
                return Json.fromJson((String)(rawValue instanceof CharSequence ? rawValue.toString() : Json.toJson((Object)rawValue)), type);
            }

            private static Character parseChar(Object rawValue) {
                String s = String.valueOf(rawValue);
                return Character.valueOf(s.isEmpty() ? (char)'\u0000' : s.charAt(0));
            }

            private static Double parseDouble(Object rawValue) {
                Double d;
                if (rawValue instanceof Number) {
                    Number x = (Number)rawValue;
                    d = x.doubleValue();
                } else {
                    d = FieldParser.parseHandlingNull(rawValue, Double::parseDouble);
                }
                return d;
            }

            private static Float parseFloat(Object rawValue) {
                Float f;
                if (rawValue instanceof Number) {
                    Number x = (Number)rawValue;
                    f = Float.valueOf(x.floatValue());
                } else {
                    f = FieldParser.parseHandlingNull(rawValue, Float::parseFloat);
                }
                return f;
            }

            private static Long parseLong(Object rawValue) {
                Long l;
                if (rawValue instanceof Number) {
                    Number x = (Number)rawValue;
                    l = x.longValue();
                } else {
                    l = FieldParser.parseHandlingNull(rawValue, Long::parseLong);
                }
                return l;
            }

            private static Integer parseInt(Object rawValue) {
                Integer n;
                if (rawValue instanceof Number) {
                    Number x = (Number)rawValue;
                    n = x.intValue();
                } else {
                    n = FieldParser.parseHandlingNull(rawValue, Integer::parseInt);
                }
                return n;
            }

            private static Short parseShort(Object rawValue) {
                Short s;
                if (rawValue instanceof Number) {
                    Number x = (Number)rawValue;
                    s = x.shortValue();
                } else {
                    s = FieldParser.parseHandlingNull(rawValue, Short::parseShort);
                }
                return s;
            }

            private static Byte parseByte(Object rawValue) {
                Byte by;
                if (rawValue instanceof Number) {
                    Number x = (Number)rawValue;
                    by = x.byteValue();
                } else {
                    by = FieldParser.parseHandlingNull(rawValue, Byte::parseByte);
                }
                return by;
            }

            private static <T extends Number> T parseHandlingNull(Object rawValue, Function<String, T> parser) {
                if (rawValue == null) {
                    return null;
                }
                String s = String.valueOf(rawValue).trim();
                if (s.isEmpty() || s.equalsIgnoreCase("null") || s.equalsIgnoreCase("none")) {
                    return null;
                }
                return (T)((Number)parser.apply(s));
            }
        }
    }
}

