/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ollama.requests;

import io.intino.alexandria.ollama.OllamaMessage;
import io.intino.alexandria.ollama.OllamaParameters;
import io.intino.alexandria.ollama.requests.OllamaRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OllamaCreateModelRequest
extends OllamaRequest
implements OllamaParameters<OllamaCreateModelRequest> {
    private String model;
    private String quantize;
    private String from;
    private Map<String, String> files;
    private Map<String, Object> parameters = new LinkedHashMap<String, Object>();
    private String template;
    private String system;
    private Map<String, String> adapters;
    private List<OllamaMessage> messages = new ArrayList<OllamaMessage>();
    private String license;
    private boolean stream;

    public String model() {
        return this.model;
    }

    public OllamaCreateModelRequest model(String model) {
        this.model = model;
        return this;
    }

    public String quantize() {
        return this.quantize;
    }

    public OllamaCreateModelRequest quantize(String quantize) {
        this.quantize = quantize;
        return this;
    }

    public String from() {
        return this.from;
    }

    public OllamaCreateModelRequest from(String modelOrPathToBinFile) {
        this.from = modelOrPathToBinFile;
        return this;
    }

    public Map<String, String> files() {
        return this.files;
    }

    public OllamaCreateModelRequest files(Map<String, String> files) {
        this.files = files;
        return this;
    }

    @Override
    public Map<String, Object> parametersMap() {
        return this.parameters;
    }

    public Map<String, Object> parameters() {
        return this.parametersMap();
    }

    public OllamaCreateModelRequest parameters(Map<String, Object> parameters) {
        this.parameters = parameters == null ? new HashMap<String, Object>(0) : new HashMap<String, Object>(parameters);
        return this;
    }

    public String template() {
        return this.template;
    }

    public OllamaCreateModelRequest template(String template) {
        this.template = template;
        return this;
    }

    public String system() {
        return this.system;
    }

    public OllamaCreateModelRequest system(String system) {
        this.system = system;
        return this;
    }

    public Map<String, String> adapters() {
        return this.adapters;
    }

    public OllamaCreateModelRequest addAdapter(String pathToLoRAGGMLFile, String sha256) {
        if (this.adapters == null) {
            this.adapters = new LinkedHashMap<String, String>();
        }
        this.adapters.put(pathToLoRAGGMLFile, sha256);
        return this;
    }

    public OllamaCreateModelRequest adapters(Map<String, String> adapters) {
        this.adapters = adapters == null ? null : new LinkedHashMap<String, String>(adapters);
        return this;
    }

    public List<OllamaMessage> messages() {
        return this.messages;
    }

    public OllamaCreateModelRequest addMessage(OllamaMessage.Role role, String content) {
        return this.addMessage(new OllamaMessage(role, content));
    }

    public OllamaCreateModelRequest addMessage(OllamaMessage message) {
        if (this.messages == null) {
            this.messages = new ArrayList<OllamaMessage>(1);
        }
        this.messages.add(message);
        return this;
    }

    public OllamaCreateModelRequest messages(Collection<OllamaMessage> messages) {
        this.messages = messages == null ? null : new ArrayList<OllamaMessage>(messages);
        return this;
    }

    public OllamaCreateModelRequest messages(OllamaMessage ... messages) {
        this.messages = messages == null ? null : Arrays.asList(messages);
        return this;
    }

    public String license() {
        return this.license;
    }

    public OllamaCreateModelRequest license(String license) {
        this.license = license;
        return this;
    }

    public boolean stream() {
        return this.stream;
    }

    public OllamaCreateModelRequest stream(boolean stream) {
        this.stream = stream;
        return this;
    }
}

