/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ollama.requests;

import com.google.gson.annotations.SerializedName;
import io.intino.alexandria.ollama.OllamaMessage;
import io.intino.alexandria.ollama.OllamaParameters;
import io.intino.alexandria.ollama.requests.OllamaRequest;
import io.intino.alexandria.ollama.tools.OllamaFunction;
import io.intino.alexandria.ollama.tools.OllamaTool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class OllamaChatRequest
extends OllamaRequest.WithOptions<OllamaChatRequest>
implements OllamaRequest.WithKeepAlive<OllamaChatRequest>,
OllamaParameters<OllamaChatRequest> {
    private String model;
    private List<OllamaMessage> messages;
    private List<OllamaTool> tools;
    private String format;
    private Boolean think;
    private boolean stream;
    @SerializedName(value="keep_alive")
    private String keepAlive;

    public String model() {
        return this.model;
    }

    public OllamaChatRequest model(String model) {
        this.model = model;
        return this;
    }

    public List<OllamaMessage> messages() {
        return this.messages;
    }

    public OllamaChatRequest addMessage(OllamaMessage.Role role, String content) {
        return this.addMessage(new OllamaMessage(role, content));
    }

    public OllamaChatRequest addMessage(OllamaMessage message) {
        if (this.messages == null) {
            this.messages = new ArrayList<OllamaMessage>();
        }
        this.messages.add(message);
        return this;
    }

    public OllamaChatRequest messages(Collection<OllamaMessage> messages) {
        this.messages = messages == null ? null : new ArrayList<OllamaMessage>(messages);
        return this;
    }

    public OllamaChatRequest messages(OllamaMessage ... messages) {
        this.messages = messages == null ? null : Arrays.asList(messages);
        return this;
    }

    public List<OllamaTool> tools() {
        return this.tools;
    }

    public OllamaChatRequest tools(Collection<OllamaTool> tools) {
        this.tools = tools == null ? null : new ArrayList<OllamaTool>(tools);
        return this;
    }

    public OllamaChatRequest tools(OllamaTool ... tools) {
        this.tools = tools == null ? null : Arrays.asList(tools);
        return this;
    }

    public OllamaChatRequest withFunction(OllamaFunction function) {
        if (this.tools == null) {
            this.tools = new ArrayList<OllamaTool>(1);
        }
        this.tools.add(OllamaTool.of(function));
        return this;
    }

    public String format() {
        return this.format;
    }

    public OllamaChatRequest format(String format) {
        this.format = format;
        return this;
    }

    public Boolean think() {
        return this.think;
    }

    public OllamaChatRequest think(Boolean think) {
        this.think = think;
        return this;
    }

    public boolean stream() {
        return this.stream;
    }

    public OllamaChatRequest stream(boolean stream) {
        this.stream = stream;
        return this;
    }

    @Override
    public String keepAlive() {
        return this.keepAlive;
    }

    @Override
    public OllamaChatRequest keepAlive(String keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    @Override
    public OllamaChatRequest self() {
        return this;
    }
}

