/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ollama;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface OllamaParameters<Self extends OllamaParameters<Self>> {
    default public Integer numGpu() {
        return (Integer)this.parameter("num_gpu");
    }

    default public Self numGpu(Integer numGpu) {
        return this.parameter("num_gpu", numGpu);
    }

    default public Integer mirostat() {
        return (Integer)this.parameter("mirostat");
    }

    default public Self mirostat(Integer mirostat) {
        return this.parameter("mirostat", mirostat);
    }

    default public Double mirostatEta() {
        return (Double)this.parameter("mirostat_eta");
    }

    default public Self mirostatEta(Double mirostatEta) {
        return this.parameter("mirostat_eta", mirostatEta);
    }

    default public Double mirostatTau() {
        return (Double)this.parameter("mirostat_tau");
    }

    default public Self mirostatTau(Double mirostatTau) {
        return this.parameter("mirostat_tau", mirostatTau);
    }

    default public Integer numCtx() {
        return (Integer)this.parameter("num_ctx");
    }

    default public Self numCtx(Integer numCtx) {
        return this.parameter("num_ctx", numCtx);
    }

    default public Integer repeatLastN() {
        return (Integer)this.parameter("repeat_last_n");
    }

    default public Self repeatLastN(Integer repeatLastN) {
        return this.parameter("repeat_last_n", repeatLastN);
    }

    default public Double repeatPenalty() {
        return (Double)this.parameter("repeat_penalty");
    }

    default public Self repeatPenalty(Double repeatPenalty) {
        return this.parameter("repeat_penalty", repeatPenalty);
    }

    default public Double temperature() {
        return (Double)this.parameter("temperature");
    }

    default public Self temperature(Double temperature) {
        return this.parameter("temperature", temperature);
    }

    default public Integer seed() {
        return (Integer)this.parameter("seed");
    }

    default public Self seed(Integer seed) {
        return this.parameter("seed", seed);
    }

    default public List<String> stop() {
        String[] stop = (String[])this.parameter("stop");
        return Arrays.asList(stop);
    }

    default public Self stop(Collection<String> stop) {
        return this.parameter("stop", stop == null ? null : stop.toArray(String[]::new));
    }

    default public Self stop(String ... stop) {
        return this.stop(stop == null ? null : Arrays.asList(stop));
    }

    default public Double tfsZ() {
        return (Double)this.parameter("tfs_z");
    }

    default public Self tfsZ(Double tfsZ) {
        return this.parameter("tfs_z", tfsZ);
    }

    default public Integer numPredict() {
        return (Integer)this.parameter("num_predict");
    }

    default public Self numPredict(Integer numPredict) {
        return this.parameter("num_predict", numPredict);
    }

    default public Integer topK() {
        return (Integer)this.parameter("top_k");
    }

    default public Self topK(Integer topK) {
        return this.parameter("top_k", topK);
    }

    default public Double topP() {
        return (Double)this.parameter("top_p");
    }

    default public Self topP(Double topP) {
        return this.parameter("top_p", topP);
    }

    default public Double minP() {
        return (Double)this.parameter("min_p");
    }

    default public Self minP(Double minP) {
        return this.parameter("min_p", minP);
    }

    public Map<String, Object> parametersMap();

    default public <T> T parameter(String name) {
        return (T)this.parametersMap().get(name);
    }

    default public Self parameter(String name, Object value) {
        if (value == null) {
            this.parametersMap().remove(name);
        }
        this.parametersMap().put(name, value);
        return this.self();
    }

    default public Self self() {
        return (Self)this;
    }
}

