/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ollama;

import com.google.gson.annotations.SerializedName;
import io.intino.alexandria.Base64;
import io.intino.alexandria.Json;
import io.intino.alexandria.ollama.tools.OllamaToolCall;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class OllamaMessage {
    private Role role = Role.user;
    private String content;
    private String thinking;
    private List<String> images;
    @SerializedName(value="tool_calls")
    private List<OllamaToolCall> toolCalls;

    public OllamaMessage() {
    }

    public OllamaMessage(String content) {
        this(Role.user, content);
    }

    public OllamaMessage(Role role, String content) {
        this.role = role;
        this.content = content;
    }

    public OllamaMessage(Role role, String content, Collection<String> images) {
        this.role = role;
        this.content = content;
        this.images(images);
    }

    public OllamaMessage(Role role, String content, Collection<String> images, Collection<OllamaToolCall> toolCalls) {
        this.role = role;
        this.content = content;
        this.images(images);
        this.toolCalls(toolCalls);
    }

    public Role role() {
        return this.role;
    }

    public OllamaMessage role(Role role) {
        this.role = role;
        return this;
    }

    public String content() {
        return this.content;
    }

    public OllamaMessage content(String content) {
        this.content = content;
        return this;
    }

    public String thinking() {
        return this.thinking;
    }

    public OllamaMessage thinking(String thinking) {
        this.thinking = thinking;
        return this;
    }

    public List<String> images() {
        return this.images;
    }

    public OllamaMessage image(File image) throws IOException {
        if (this.images == null) {
            this.images = new ArrayList<String>(1);
        }
        this.images.add(Base64.encode((byte[])Files.readAllBytes(image.toPath())));
        return this;
    }

    public OllamaMessage image(String imagePathOrBase64) {
        if (this.images == null) {
            this.images = new ArrayList<String>(1);
        }
        this.images.add(imagePathOrBase64);
        return this;
    }

    public OllamaMessage images(Collection<String> images) {
        this.images = images == null ? null : new ArrayList<String>(images);
        return this;
    }

    public OllamaMessage images(String ... images) {
        this.images = Arrays.asList(images);
        return this;
    }

    public boolean hasToolCalls() {
        return this.toolCalls != null && !this.toolCalls.isEmpty();
    }

    public OllamaToolCall toolCall(int index) {
        return this.toolCalls.get(index);
    }

    public int toolCallsCount() {
        return this.toolCalls == null ? 0 : this.toolCalls.size();
    }

    public List<OllamaToolCall> toolCalls() {
        return this.toolCalls;
    }

    public OllamaMessage toolCalls(Collection<OllamaToolCall> toolCalls) {
        this.toolCalls = toolCalls == null ? null : new ArrayList<OllamaToolCall>(toolCalls);
        return this;
    }

    public OllamaMessage toolCalls(OllamaToolCall ... toolCalls) {
        this.toolCalls = toolCalls == null ? null : Arrays.asList(toolCalls);
        return this;
    }

    public String toString() {
        return Json.toJson((Object)this);
    }

    public static enum Role {
        system,
        user,
        assistant;

    }
}

