/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ollama;

import io.intino.alexandria.Json;
import io.intino.alexandria.ollama.OllamaAPIException;
import io.intino.alexandria.ollama.OllamaHttpClient;
import io.intino.alexandria.ollama.OllamaMessage;
import io.intino.alexandria.ollama.requests.OllamaChatRequest;
import io.intino.alexandria.ollama.requests.OllamaCopyRequest;
import io.intino.alexandria.ollama.requests.OllamaCreateModelRequest;
import io.intino.alexandria.ollama.requests.OllamaEmbedRequest;
import io.intino.alexandria.ollama.requests.OllamaGenerateRequest;
import io.intino.alexandria.ollama.requests.OllamaPullRequest;
import io.intino.alexandria.ollama.requests.OllamaPushRequest;
import io.intino.alexandria.ollama.requests.OllamaShowRequest;
import io.intino.alexandria.ollama.responses.OllamaChatResponse;
import io.intino.alexandria.ollama.responses.OllamaCreateModelResponse;
import io.intino.alexandria.ollama.responses.OllamaEmbedResponse;
import io.intino.alexandria.ollama.responses.OllamaGenerateResponse;
import io.intino.alexandria.ollama.responses.OllamaListResponse;
import io.intino.alexandria.ollama.responses.OllamaPsResponse;
import io.intino.alexandria.ollama.responses.OllamaPullResponse;
import io.intino.alexandria.ollama.responses.OllamaPushResponse;
import io.intino.alexandria.ollama.responses.OllamaShowResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Ollama
extends AutoCloseable {
    public static Ollama newClient() {
        return new OllamaHttpClient();
    }

    public static Ollama newClient(String baseUrl) {
        return new OllamaHttpClient(baseUrl);
    }

    public static Ollama newClient(String baseUrl, Duration timeout) {
        return new OllamaHttpClient(baseUrl, timeout);
    }

    default public OllamaChatResponse chat(String model, String message) throws OllamaAPIException {
        return this.chat(new OllamaChatRequest().model(model).addMessage(OllamaMessage.Role.user, message).stream(false));
    }

    default public OllamaChatResponse chat(String model, OllamaMessage ... messages) throws OllamaAPIException {
        return this.chat(new OllamaChatRequest().model(model).messages(messages).stream(false));
    }

    public OllamaChatResponse chat(OllamaChatRequest var1) throws OllamaAPIException;

    default public StreamResponse<OllamaChatResponse> chatStream(String model, String message) throws OllamaAPIException {
        return this.chatStream(new OllamaChatRequest().model(model).addMessage(OllamaMessage.Role.user, message).stream(true));
    }

    default public StreamResponse<OllamaChatResponse> chatStream(String model, OllamaMessage ... messages) throws OllamaAPIException {
        return this.chatStream(new OllamaChatRequest().model(model).messages(messages).stream(true));
    }

    public StreamResponse<OllamaChatResponse> chatStream(OllamaChatRequest var1) throws OllamaAPIException;

    default public OllamaGenerateResponse generate(String model, String prompt) throws OllamaAPIException {
        return this.generate(new OllamaGenerateRequest().model(model).prompt(prompt).stream(false));
    }

    public OllamaGenerateResponse generate(OllamaGenerateRequest var1) throws OllamaAPIException;

    default public StreamResponse<OllamaGenerateResponse> generateStream(String model, String prompt) throws OllamaAPIException {
        return this.generateStream(new OllamaGenerateRequest().model(model).prompt(prompt).stream(true));
    }

    public StreamResponse<OllamaGenerateResponse> generateStream(OllamaGenerateRequest var1) throws OllamaAPIException;

    public OllamaEmbedResponse.OfDouble embed(OllamaEmbedRequest var1) throws OllamaAPIException;

    public OllamaEmbedResponse.OfFloat embedFloats(OllamaEmbedRequest var1) throws OllamaAPIException;

    public OllamaCreateModelResponse createModel(OllamaCreateModelRequest var1) throws OllamaAPIException;

    public StreamResponse<OllamaCreateModelResponse> createModelStream(OllamaCreateModelRequest var1) throws OllamaAPIException;

    public OllamaListResponse list() throws OllamaAPIException;

    default public OllamaShowResponse show(String name, boolean verbose) throws OllamaAPIException {
        return this.show(new OllamaShowRequest().name(name).verbose(verbose));
    }

    public OllamaShowResponse show(OllamaShowRequest var1) throws OllamaAPIException;

    default public boolean pullIfNotExists(String model) throws OllamaAPIException {
        if (!this.exists(model)) {
            this.pull(model);
            return true;
        }
        return false;
    }

    default public OllamaPullResponse pull(String model) throws OllamaAPIException {
        return this.pull(new OllamaPullRequest().name(model).stream(false));
    }

    public OllamaPullResponse pull(OllamaPullRequest var1) throws OllamaAPIException;

    default public StreamResponse<OllamaPullResponse> pullStream(String model) throws OllamaAPIException {
        return this.pullStream(new OllamaPullRequest().name(model).stream(true));
    }

    public StreamResponse<OllamaPullResponse> pullStream(OllamaPullRequest var1) throws OllamaAPIException;

    public OllamaPushResponse push(OllamaPushRequest var1) throws OllamaAPIException;

    public StreamResponse<OllamaPushResponse> pushStream(OllamaPushRequest var1) throws OllamaAPIException;

    public OllamaPsResponse ps() throws OllamaAPIException;

    public void copy(OllamaCopyRequest var1) throws OllamaAPIException;

    default public boolean exists(String model) throws OllamaAPIException {
        if (model == null) {
            return false;
        }
        model = model.replace(":latest", "");
        return this.list().modelNames().contains(model);
    }

    public void delete(String var1) throws OllamaAPIException;

    default public boolean deleteIfExists(String name) throws OllamaAPIException {
        if (this.exists(name)) {
            this.delete(name);
            return true;
        }
        return false;
    }

    public boolean existsBlob(String var1) throws OllamaAPIException;

    public void createBlob(File var1, String var2) throws OllamaAPIException, FileNotFoundException;

    public void createBlob(File var1) throws OllamaAPIException, FileNotFoundException;

    public String baseUrl();

    public Duration timeout();

    public Ollama timeout(Duration var1);

    public Ollama setCommonHeader(String var1, String var2);

    @Override
    public void close();

    public static String sha256(File file) throws OllamaAPIException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            try (DigestInputStream dis = new DigestInputStream(new FileInputStream(file), digest);){
                byte[] buffer = new byte[8192];
                while (dis.read(buffer) != -1) {
                }
            }
            return Ollama.bytesToHex(digest.digest());
        }
        catch (Exception e) {
            throw new OllamaAPIException(e);
        }
    }

    public static String bytesToHex(byte[] hash) {
        try (Formatter formatter = new Formatter();){
            for (byte b : hash) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString();
            return string;
        }
    }

    public static class StreamResponse<T>
    implements AutoCloseable,
    Iterator<T>,
    Iterable<T> {
        private final BufferedReader reader;
        private final Iterator<T> iterator;

        public StreamResponse(InputStream inputStream, Class<T> responseType) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
            this.iterator = this.reader.lines().filter(l -> !l.isBlank()).map(l -> Json.fromJson((String)l, (Class)responseType)).iterator();
        }

        public String processAllParts() {
            return this.processAllParts(part -> {});
        }

        public String processAllParts(Consumer<T> consumer) {
            StringBuilder sb = new StringBuilder();
            while (this.hasNext()) {
                T part = this.next();
                consumer.accept(part);
                sb.append(this.textOf(part));
            }
            return sb.toString();
        }

        private String textOf(T part) {
            if (part instanceof OllamaGenerateResponse) {
                OllamaGenerateResponse g = (OllamaGenerateResponse)part;
                return g.text();
            }
            if (part instanceof OllamaChatResponse) {
                OllamaChatResponse c = (OllamaChatResponse)part;
                return c.text();
            }
            return "";
        }

        public Stream<T> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        public List<T> toList() {
            return this.stream().toList();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public void close() throws Exception {
            this.reader.close();
        }
    }
}

