/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.nessaccessor;

import io.intino.alexandria.inl.Message;
import io.intino.alexandria.jms.MessageFactory;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zim.ZimReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.TextMessage;

public class MessageTranslator {
    private static String ATTACHMENT_IDS = "__attachment-ids__";
    private static String ATTACHMENT_SIZES = "__attachment-sizes__";
    private static String MESSAGE = "__text-message__";

    public static Message toInlMessage(javax.jms.Message message) {
        try {
            if (message instanceof BytesMessage) {
                Message result = new ZimReader(message.getStringProperty(MESSAGE)).next();
                Map<String, Integer> attachments = MessageTranslator.loadAttachmentProperties(message);
                for (String id : attachments.keySet()) {
                    byte[] array = new byte[attachments.get(id).intValue()];
                    ((BytesMessage)message).readBytes(array, attachments.get(id).intValue());
                    result.attachment(id).data(array);
                }
                return result;
            }
            return new ZimReader(((TextMessage)message).getText()).next();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public static javax.jms.Message fromInlMessage(Message message) {
        List<Message.Attachment> attachments = MessageTranslator.getAttachments(message);
        if (!attachments.isEmpty()) {
            javax.jms.Message result = MessageFactory.byteMessage();
            MessageTranslator.addAttachments((BytesMessage)result, attachments);
            MessageTranslator.addTextMessage(message, (BytesMessage)result);
            return result;
        }
        return MessageFactory.createMessageFor((Object)message.toString());
    }

    private static List<Message.Attachment> getAttachments(Message message) {
        ArrayList<Message.Attachment> attachments = new ArrayList<Message.Attachment>(message.attachments());
        message.components().stream().map(MessageTranslator::getAttachments).forEach(attachments::addAll);
        return attachments;
    }

    private static Map<String, Integer> loadAttachmentProperties(javax.jms.Message message) {
        try {
            String[] ids = message.getStringProperty(ATTACHMENT_IDS).split(",");
            String[] sizes = message.getStringProperty(ATTACHMENT_SIZES).split(",");
            return IntStream.range(0, ids.length).boxed().collect(Collectors.toMap(i -> ids[i], i -> Integer.parseInt(sizes[i])));
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
            return Collections.emptyMap();
        }
    }

    private static void addTextMessage(Message message, BytesMessage result) {
        try {
            result.setStringProperty(MESSAGE, message.toString());
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
        }
    }

    private static void addAttachments(BytesMessage bytesMessage, List<Message.Attachment> attachments) {
        try {
            bytesMessage.setStringProperty(ATTACHMENT_IDS, String.join((CharSequence)",", (CharSequence[])attachments.stream().map(Message.Attachment::id).toArray(String[]::new)));
            bytesMessage.setStringProperty(ATTACHMENT_SIZES, String.join((CharSequence)",", (CharSequence[])attachments.stream().map(a -> a.data().length + "").toArray(String[]::new)));
            for (Message.Attachment attachment : attachments) {
                bytesMessage.writeBytes(attachment.data());
            }
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
        }
    }
}

