/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.nessaccessor.tcp;

import io.intino.alexandria.jms.Consumer;
import io.intino.alexandria.jms.MessageFactory;
import io.intino.alexandria.jms.TopicProducer;
import io.intino.alexandria.logger.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;

public class AdminService {
    private final String ADMIN_PATH = "service.ness.admin";
    private final Session session;

    public AdminService(Session session) {
        this.session = session;
    }

    String request(String query) {
        try {
            TopicProducer producer = this.newProducer();
            if (producer == null) {
                return "";
            }
            Message message = MessageFactory.createMessageFor((Object)query);
            message.setJMSReplyTo((Destination)this.session.createTemporaryQueue());
            producer.produce(message);
            Message response = this.session.createConsumer(message.getJMSReplyTo()).receive(1000L);
            return response == null ? "" : Consumer.textFrom((Message)response);
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
            return "";
        }
    }

    void send(String message) {
        TopicProducer producer = this.newProducer();
        if (producer == null) {
            return;
        }
        producer.produce(MessageFactory.createMessageFor((Object)message));
        producer.close();
    }

    private TopicProducer newProducer() {
        try {
            return new TopicProducer(this.session, "service.ness.admin");
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }
}

